/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.exception;

import eu.europeana.thumbnail.exception.ThumbnailException;
import eu.europeana.thumbnail.model.ErrorResponse;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger LOG = LogManager.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={ThumbnailException.class})
    public void handleThumbnailException(ThumbnailException e) throws ThumbnailException {
        if (e.doLog()) {
            if (e.logStacktrace()) {
                LOG.error("Caught exception", (Throwable)e);
            } else {
                LOG.error("Caught exception: {}", (Object)e.getMessage());
            }
        }
        throw e;
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public final ResponseEntity<ErrorResponse> handleConstraintViolation(HttpServletResponse response, ConstraintViolationException ex) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        ErrorResponse error = new ErrorResponse(HttpStatus.BAD_REQUEST, ex.getMessage());
        return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
    }
}

