/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import eu.europeana.thumbnail.model.ErrorResponse;
import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.utils.ControllerUtils;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/thumbnail"})
public class ThumbnailControllerV3 {
    private static final Logger LOG = LogManager.getLogger(ThumbnailControllerV3.class);
    private static final boolean LOG_DEBUG_ENABLED = LOG.isDebugEnabled();
    private static final long DURATION_CONVERTER = 10000L;
    private MediaStorageService metisobjectStorageClient;
    private MediaStorageService uimObjectStorageClient;

    public ThumbnailControllerV3(MediaStorageService metisobjectStorageClient, MediaStorageService uimObjectStorageClient) {
        this.metisobjectStorageClient = metisobjectStorageClient;
        this.uimObjectStorageClient = uimObjectStorageClient;
    }

    @GetMapping(value={"/v3/{size}/{url}"})
    public ResponseEntity<byte[]> thumbnailByUrl(@PathVariable(value="size") String size, @PathVariable(value="url") String url, WebRequest webRequest, HttpServletResponse response) {
        ResponseEntity result;
        int sizeValue;
        long startTime = 0L;
        String decodedURL = URLDecoder.decode(url, StandardCharsets.UTF_8);
        String cleanedURL = decodedURL.split("\\.")[0];
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        HttpHeaders headers = new HttpHeaders();
        try {
            sizeValue = Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            return this.sizeErrorMessage(size, headers);
        }
        if (LOG_DEBUG_ENABLED) {
            LOG.debug("Thumbnail url = {}, cleanedURL = {} , size = {}", (Object)url, (Object)cleanedURL, (Object)sizeValue);
        }
        if (sizeValue == 200 || sizeValue == 400) {
            MediaFile mediaFile = this.retrieveThumbnail(cleanedURL, String.valueOf(sizeValue));
            if (mediaFile == null) {
                result = new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            } else {
                headers.setContentType(this.getMediaType(url));
                byte[] mediaContent = mediaFile.getContent();
                result = new ResponseEntity((Object)mediaContent, (MultiValueMap)headers, HttpStatus.OK);
                if (ControllerUtils.checkForNotModified((MediaFile)mediaFile, (WebRequest)webRequest)) {
                    result = null;
                }
                if (ControllerUtils.checkForPrecondition((MediaFile)mediaFile, (WebRequest)webRequest)) {
                    result = new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
                }
            }
        } else {
            return this.sizeErrorMessage(size, headers);
        }
        if (LOG_DEBUG_ENABLED) {
            Long duration = (System.nanoTime() - startTime) / 10000L;
            if (MediaType.IMAGE_PNG.equals((Object)headers.getContentType())) {
                LOG.debug("Total thumbnail request time (missing media): {}", (Object)duration);
            } else if (result == null) {
                LOG.debug("Total thumbnail request time (from s3 + return 304): {}", (Object)duration);
            } else {
                LOG.debug("Total thumbnail request time (from s3 + return 200): {}", (Object)duration);
            }
        }
        return result;
    }

    private ResponseEntity<byte[]> sizeErrorMessage(String wrongSize, HttpHeaders headers) {
        String message = String.format("'%s' is not a valid size parameter", wrongSize);
        ArrayList<String> details = new ArrayList<String>();
        details.add("It must be either 200 or 400");
        return new ResponseEntity((Object)new ErrorResponse(message, details), (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
    }

    private MediaFile retrieveThumbnail(String url, String size) {
        String mediaFileId = this.computeResourceUrl(url, size);
        LOG.debug("id = {}", (Object)mediaFileId);
        MediaFile mediaFile = this.metisobjectStorageClient.retrieveAsMediaFile(mediaFileId, url, true);
        LOG.debug("Metis thumbnail = {}", (Object)mediaFile);
        if (mediaFile == null) {
            mediaFile = this.uimObjectStorageClient.retrieveAsMediaFile(mediaFileId, url, true);
            LOG.debug("UIM thumbnail = {}", (Object)mediaFile);
        }
        return mediaFile;
    }

    private MediaType getMediaType(String url) {
        String urlLow = url.toLowerCase(Locale.GERMAN);
        if (urlLow.endsWith(".png") || urlLow.endsWith(".pdf")) {
            return MediaType.IMAGE_PNG;
        }
        return MediaType.IMAGE_JPEG;
    }

    private String computeResourceUrl(String resourceUrl, String resourceSize) {
        return resourceUrl + "-" + (StringUtils.equalsIgnoreCase((CharSequence)resourceSize, (CharSequence)"200") ? "MEDIUM" : "LARGE");
    }
}

