/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.utils.ControllerUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api"})
@Validated
public class ThumbnailController {
    private static final Logger LOG = LogManager.getLogger(ThumbnailController.class);
    private static final String IIIF_HOST_NAME = "iiif.europeana.eu";
    private static final boolean LOG_DEBUG_ENABLED = LOG.isDebugEnabled();
    private static final long DURATION_CONVERTER = 10000L;
    private static final String INVALID_URL_MESSAGE = "INVALID URL";
    private MediaStorageService metisobjectStorageClient;
    private MediaStorageService uimObjectStorageClient;

    public ThumbnailController(MediaStorageService metisobjectStorageClient, MediaStorageService uimObjectStorageClient) {
        this.metisobjectStorageClient = metisobjectStorageClient;
        this.uimObjectStorageClient = uimObjectStorageClient;
    }

    @GetMapping(value={"/v2/thumbnail-by-url.json"})
    public ResponseEntity<byte[]> thumbnailByUrl(@RequestParam(value="uri") @Pattern(regexp="^(https?|ftp)://.*$", message="INVALID URL") @Pattern(regexp="^(https?|ftp)://.*$", message="INVALID URL") String url, @RequestParam(value="size", required=false, defaultValue="w400") String size, @RequestParam(value="type", required=false, defaultValue="IMAGE") String type, WebRequest webRequest, HttpServletResponse response) {
        ResponseEntity result;
        long startTime = 0L;
        HttpHeaders headers = new HttpHeaders();
        if (LOG_DEBUG_ENABLED) {
            startTime = System.nanoTime();
            LOG.debug("Thumbnail url = {}, size = {}, type = {}", (Object)url, (Object)size, (Object)type);
        }
        MediaFile mediaFile = this.retrieveThumbnail(url, size);
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        if (mediaFile == null) {
            headers.setContentType(MediaType.IMAGE_PNG);
            byte[] mediaContent = this.getDefaultThumbnailForNotFoundResourceByType(type);
            result = new ResponseEntity((Object)mediaContent, (MultiValueMap)headers, HttpStatus.OK);
        } else {
            headers.setContentType(this.getMediaType(url));
            byte[] mediaContent = mediaFile.getContent();
            result = new ResponseEntity((Object)mediaContent, (MultiValueMap)headers, HttpStatus.OK);
            if (ControllerUtils.checkForNotModified((MediaFile)mediaFile, (WebRequest)webRequest)) {
                result = null;
            }
            if (ControllerUtils.checkForPrecondition((MediaFile)mediaFile, (WebRequest)webRequest)) {
                result = new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
            }
        }
        if (LOG_DEBUG_ENABLED) {
            Long duration = (System.nanoTime() - startTime) / 10000L;
            if (MediaType.IMAGE_PNG.equals((Object)headers.getContentType())) {
                LOG.debug("Total thumbnail request time (missing media): {}", (Object)duration);
            } else if (result == null) {
                LOG.debug("Total thumbnail request time (from s3 + return 304): {}", (Object)duration);
            } else {
                LOG.debug("Total thumbnail request time (from s3 + return 200): {}", (Object)duration);
            }
        }
        return result;
    }

    private MediaFile retrieveThumbnail(String url, String size) {
        String mediaFileId = this.computeResourceUrl(url, size);
        LOG.debug("id = {}", (Object)mediaFileId);
        MediaFile mediaFile = this.metisobjectStorageClient.retrieveAsMediaFile(mediaFileId, url, true);
        LOG.debug("Metis thumbnail = {}", (Object)mediaFile);
        if (mediaFile == null) {
            mediaFile = this.uimObjectStorageClient.retrieveAsMediaFile(mediaFileId, url, true);
            LOG.debug("UIM thumbnail = {}", (Object)mediaFile);
        }
        if (mediaFile == null && ThumbnailController.isIiifRecordUrl((String)url)) {
            try {
                String width = StringUtils.equalsIgnoreCase((CharSequence)size, (CharSequence)"w200") ? "200" : "400";
                URI iiifUri = ThumbnailController.getIiifThumbnailUrl((String)url, (String)width);
                if (iiifUri != null) {
                    LOG.debug("IIIF url = {} ", (Object)iiifUri.getPath());
                    mediaFile = this.downloadImage(iiifUri);
                }
            }
            catch (URISyntaxException e) {
                LOG.error("Error reading IIIF thumbnail url {}", (Object)url, (Object)e);
            }
            catch (IOException io) {
                LOG.error("Error retrieving IIIF thumbnail image {} ", (Object)url, (Object)io);
            }
        }
        return mediaFile;
    }

    private MediaType getMediaType(String url) {
        String urlLow = url.toLowerCase(Locale.GERMAN);
        if (urlLow.endsWith(".png") || urlLow.endsWith(".pdf")) {
            return MediaType.IMAGE_PNG;
        }
        return MediaType.IMAGE_JPEG;
    }

    @Deprecated(since="2.1", forRemoval=true)
    static boolean isIiifRecordUrl(String url) {
        if (url != null) {
            String urlLowercase = url.toLowerCase(Locale.GERMAN);
            return urlLowercase.startsWith("http://iiif.europeana.eu") || urlLowercase.startsWith("https://iiif.europeana.eu");
        }
        return false;
    }

    @Deprecated(since="2.1", forRemoval=true)
    static URI getIiifThumbnailUrl(String url, String width) throws URISyntaxException {
        if (ThumbnailController.isIiifRecordUrl((String)url)) {
            return new URI(url.replace("/full/full/0/default.", "/full/" + width + ",/0/default."));
        }
        return null;
    }

    @Deprecated(since="2.1", forRemoval=true)
    private MediaFile downloadImage(URI uri) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(uri.toURL().openStream());){
            MediaFile mediaFile;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int n;
                byte[] buf = new byte[1024];
                while (-1 != (n = ((InputStream)in).read(buf))) {
                    out.write(buf, 0, n);
                }
                mediaFile = new MediaFile(this.getMD5(uri.getPath()), uri.getPath(), out.toByteArray());
            }
            return mediaFile;
        }
    }

    private byte[] getImage(String path) {
        byte[] result = null;
        try (InputStream in = this.getClass().getResourceAsStream(path);){
            result = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            LOG.error("Error reading default thumbnail file", (Throwable)e);
        }
        return result;
    }

    private String getMD5(String resourceUrl) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(resourceUrl.getBytes(StandardCharsets.UTF_8));
            byte[] resultByte = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte aResultByte : resultByte) {
                sb.append(Integer.toString((aResultByte & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error determining MD5 for resource {}", (Object)resourceUrl, (Object)e);
            return resourceUrl;
        }
    }

    private byte[] getDefaultThumbnailForNotFoundResourceByType(String type) {
        switch (StringUtils.upperCase((String)type)) {
            case "IMAGE": {
                return this.getImage("/images/EU_thumbnails_image.png");
            }
            case "SOUND": {
                return this.getImage("/images/EU_thumbnails_sound.png");
            }
            case "VIDEO": {
                return this.getImage("/images/EU_thumbnails_video.png");
            }
            case "TEXT": {
                return this.getImage("/images/EU_thumbnails_text.png");
            }
            case "3D": {
                return this.getImage("/images/EU_thumbnails_3d.png");
            }
        }
        return this.getImage("/images/EU_thumbnails_image.png");
    }

    private String computeResourceUrl(String resourceUrl, String resourceSize) {
        return this.getMD5(resourceUrl) + "-" + (StringUtils.equalsIgnoreCase((CharSequence)resourceSize, (CharSequence)"w200") ? "MEDIUM" : "LARGE");
    }
}

