/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.service.impl;

import eu.europeana.domain.ObjectMetadata;
import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.MediaStorageService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.io.Payload;

public class MediaStorageServiceImpl
implements MediaStorageService {
    private static final Logger LOG = LogManager.getLogger(MediaStorageServiceImpl.class);
    private ObjectStorageClient objectStorageClient;

    public MediaStorageServiceImpl(ObjectStorageClient objectStorageClient) {
        this.objectStorageClient = objectStorageClient;
    }

    public Boolean checkIfExists(String id) {
        return this.objectStorageClient.isAvailable(id);
    }

    public MediaFile retrieveAsMediaFile(String id, String originalUrl, boolean withContent) {
        StorageObject storageObject = this.retrieveAsStorageObject(id, withContent);
        if (storageObject == null) {
            return null;
        }
        byte[] content = null;
        if (withContent) {
            try {
                content = this.convertPayloadToByteArray(storageObject.getPayload());
            }
            catch (IOException e) {
                LOG.error("Error reading media file contents {}", (Object)id, (Object)e);
            }
        }
        return new MediaFile(storageObject.getName(), originalUrl, content, storageObject.getMetadata());
    }

    public StorageObject retrieveAsStorageObject(String id, boolean withContent) {
        Optional optStorageObject = withContent ? this.objectStorageClient.get(id) : this.objectStorageClient.getWithoutBody(id);
        return optStorageObject.orElse(null);
    }

    public byte[] convertPayloadToByteArray(Payload payload) throws IOException {
        byte[] result;
        try (InputStream in = payload.openStream();){
            result = IOUtils.toByteArray((InputStream)in);
        }
        return result;
    }

    public byte[] retrieveContent(String id) {
        return this.objectStorageClient.getContent(id);
    }

    public ObjectMetadata retrieveMetaData(String id) {
        return this.objectStorageClient.getMetaData(id);
    }
}

