/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.service.exception;

import eu.europeana.thumbnail.model.ErrorResponse;
import eu.europeana.thumbnail.service.exception.ThumbnailException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger LOG = LogManager.getLogger(GlobalExceptionHandler.class);
    private static final String BAD_REQUEST = "BAD_REQUEST";

    @ExceptionHandler(value={ThumbnailException.class})
    public void handleThumbnailException(ThumbnailException e) throws ThumbnailException {
        if (e.doLog()) {
            LOG.error("Caught exception", (Throwable)e);
        }
        throw e;
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public final ResponseEntity<ErrorResponse> handleConstraintViolation(ConstraintViolationException ex) {
        List details = ex.getConstraintViolations().parallelStream().map(e -> e.getMessage()).collect(Collectors.toList());
        ErrorResponse error = new ErrorResponse(BAD_REQUEST, details);
        return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
    }
}

