/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.model;

import eu.europeana.domain.ObjectMetadata;
import org.joda.time.DateTime;

public class MediaFile {
    private final String id;
    private final String originalUrl;
    private final byte[] content;
    private final ObjectMetadata metaData;

    public MediaFile(String id, String originalUrl, byte[] content) {
        this(id, originalUrl, content, null);
    }

    public MediaFile(String id, String originalUrl, byte[] content, ObjectMetadata metadata) {
        this.id = id;
        this.originalUrl = originalUrl;
        this.content = content;
        this.metaData = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getContentLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    public DateTime getLastModified() {
        if (this.metaData == null) {
            return null;
        }
        return new DateTime(this.metaData.getLastModified().getTime());
    }

    public String getETag() {
        if (this.metaData == null) {
            return null;
        }
        return this.metaData.getETag();
    }
}

