/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.config;

import eu.europeana.features.ObjectStorageClient;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.service.impl.MediaStorageServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Component;

@Configuration
@Component
@PropertySources(value={@PropertySource(value={"classpath:thumbnail.properties"}), @PropertySource(value={"classpath:thumbnail.user.properties"}, ignoreResourceNotFound=true)})
public class ThumbnailConfiguration {
    @Value(value="${metis.thumbnails.s3.key}")
    private String metisThumbnailS3Key;
    @Value(value="${metis.thumbnails.s3.secret}")
    private String metisThumbnailS3Secret;
    @Value(value="${metis.thumbnails.s3.region}")
    private String metisThumbnailS3Region;
    @Value(value="${metis.thumbnails.s3.bucket}")
    private String metisThumbnailS3Bucket;
    @Value(value="${metis.thumbnails.s3.endpoint}")
    private String metisThumbnailS3Endpoint;
    @Value(value="${uim.thumbnails.s3.key}")
    private String uimThumbnailS3Key;
    @Value(value="${uim.thumbnails.s3.secret}")
    private String uimThumbnailS3Secret;
    @Value(value="${uim.thumbnails.s3.region}")
    private String uimThumbnailS3Region;
    @Value(value="${uim.thumbnails.s3.bucket}")
    private String uimThumbnailS3Bucket;

    @Bean
    public MediaStorageService metisobjectStorageClient() {
        return new MediaStorageServiceImpl((ObjectStorageClient)new S3ObjectStorageClient(this.metisThumbnailS3Key, this.metisThumbnailS3Secret, this.metisThumbnailS3Region, this.metisThumbnailS3Bucket, this.metisThumbnailS3Endpoint));
    }

    @Bean
    public MediaStorageService uimObjectStorageClient() {
        return new MediaStorageServiceImpl((ObjectStorageClient)new S3ObjectStorageClient(this.uimThumbnailS3Key, this.uimThumbnailS3Secret, this.uimThumbnailS3Region, this.uimThumbnailS3Bucket));
    }
}

