/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho.repo;

import eu.europeana.keycloak.zoho.datamodel.KeycloakClient;
import eu.europeana.keycloak.zoho.datamodel.KeycloakUser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CustomQueryRepository {
    private final EntityManager em;

    public CustomQueryRepository(EntityManager em) {
        this.em = em;
    }

    public String findTestGroupId() {
        String query = "SELECT gi.id FROM  GroupEntity gi WHERE gi.name=:groupname";
        try {
            return (String)this.em.createQuery(query, String.class).setParameter("groupname", (Object)"Europeana Test Users").getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> findTestGroupUsers(String groupId) {
        String query = "SELECT uge.user.id FROM  UserGroupMembershipEntity uge WHERE uge.groupId=:groupID";
        return this.em.createQuery(query, String.class).setParameter("groupID", (Object)groupId).getResultList();
    }

    public Map<String, KeycloakUser> listAllUserMails(String realmName) {
        HashMap<String, KeycloakUser> userDetailsMap = new HashMap<String, KeycloakUser>();
        String nativeQueryString = "SELECT\n    u.ID,u.USERNAME,u.EMAIL,u.FIRST_NAME ,u.LAST_NAME,\n    STRING_AGG(kr.NAME, ', ' ORDER BY kr.NAME) AS roles\nFROM\n    {h-schema}USER_ENTITY u\nLEFT JOIN\n    {h-schema}USER_ROLE_MAPPING urm ON u.ID = urm.USER_ID\nLEFT JOIN\n    {h-schema}KEYCLOAK_ROLE kr ON urm.ROLE_ID = kr.ID\nWHERE u.realm_id = %s AND u.enabled = true AND u.service_account_client_link is null\nGROUP BY\n    u.ID,u.USERNAME,u.EMAIL,u.FIRST_NAME ,u.LAST_NAME\nORDER BY u.EMAIL".formatted("'" + realmName + "'");
        Query nativeQuery = this.em.createNativeQuery(nativeQueryString);
        List rows = nativeQuery.getResultList();
        for (Object[] row : rows) {
            String id = (String)row[0];
            String username = (String)row[1];
            String email = (String)row[2];
            String firstName = (String)row[3];
            String lastName = (String)row[4];
            String roles = (String)row[5];
            userDetailsMap.put(email, new KeycloakUser(id, username, email, firstName, lastName, roles));
        }
        return userDetailsMap;
    }

    public Map<String, KeycloakClient> getProjectClients(String realmName) {
        String nativeQueryString = "SELECT c.client_id as apikey,ra.name as attribute_name,ra.value as attribute_value\nFROM\n{h-schema}CLIENT c\nJOIN\n{h-schema}KEYCLOAK_ROLE kr ON kr.client = c.id\nJOIN\n{h-schema}ROLE_ATTRIBUTE ra ON kr.id=ra.role_id\nWHERE kr.name in ('shared_owner')\nAND  c.realm_id = :realmName\n";
        Query nativeQuery = this.em.createNativeQuery(nativeQueryString).setParameter("realmName", (Object)realmName);
        List rows = nativeQuery.getResultList();
        HashMap<String, KeycloakClient> clientMap = new HashMap<String, KeycloakClient>();
        for (Object[] row : rows) {
            String apikey = String.valueOf(row[0]);
            String attributeName = String.valueOf(row[1]);
            String attributeValue = String.valueOf(row[2]);
            KeycloakClient client = (KeycloakClient)clientMap.get(apikey);
            if (client == null) {
                HashMap<String, String> attributemap = new HashMap<String, String>();
                if (StringUtils.isNotEmpty((CharSequence)attributeName)) {
                    attributemap.put(attributeName, attributeValue);
                }
                clientMap.put(apikey, new KeycloakClient(apikey, attributemap));
                continue;
            }
            client.addAttribute(attributeName, attributeValue);
        }
        return clientMap;
    }
}

