/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho.batch;

import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.record.APIException;
import com.zoho.crm.api.record.ActionHandler;
import com.zoho.crm.api.record.ActionResponse;
import com.zoho.crm.api.record.ActionWrapper;
import com.zoho.crm.api.record.BodyWrapper;
import com.zoho.crm.api.record.Record;
import com.zoho.crm.api.record.RecordOperations;
import com.zoho.crm.api.record.SuccessResponse;
import com.zoho.crm.api.util.APIResponse;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;

public class ZohoBatchUpdater {
    private static final Logger LOG = Logger.getLogger(ZohoBatchUpdater.class);
    public static final int BATCH_SIZE = 100;

    public void updateInBatches(List<Record> records, String moduleName) throws SDKException {
        if (records == null || records.isEmpty()) {
            return;
        }
        int totalRecords = records.size();
        LOG.info((Object)("Batch update process started for module '" + moduleName + "'"));
        LOG.info((Object)("Total number of records to update - " + totalRecords));
        for (int i = 0; i <= totalRecords; i += 100) {
            int endIndex = Math.min(i + 100, totalRecords);
            List<Record> currentBatch = records.subList(i, endIndex);
            LOG.info((Object)("Processing batch number " + (i / 100 + 1) + " Records from - " + (i + 1) + " To- " + endIndex));
            if (this.callZohoBatchUpdate(new ArrayList<Record>(currentBatch), moduleName)) continue;
            LOG.error((Object)"Further batches if any ,wont be processed due to failure");
            return;
        }
        LOG.info((Object)"Batch update process finished.");
    }

    private boolean callZohoBatchUpdate(List<Record> records, String moduleAPIName) throws SDKException {
        RecordOperations recordOperations = new RecordOperations(moduleAPIName);
        BodyWrapper request = new BodyWrapper();
        request.setData(records);
        APIResponse response = recordOperations.updateRecords(request, new HeaderMap());
        return this.processResponse((APIResponse<ActionHandler>)response);
    }

    public boolean processResponse(APIResponse<ActionHandler> response) {
        if (response != null && response.isExpected()) {
            Object object = response.getObject();
            if (object instanceof ActionWrapper) {
                ActionWrapper actionWrapper = (ActionWrapper)object;
                for (ActionResponse actionResponse : actionWrapper.getData()) {
                    if (actionResponse instanceof SuccessResponse) {
                        return true;
                    }
                    if (!(actionResponse instanceof APIException)) continue;
                    APIException exception = (APIException)actionResponse;
                    LOG.error((Object)("Status: " + (String)exception.getStatus().getValue() + " Code:" + (String)exception.getCode().getValue() + " Message: " + (String)exception.getMessage().getValue()));
                    return false;
                }
            } else {
                object = response.getObject();
                if (object instanceof APIException) {
                    APIException exception = (APIException)object;
                    LOG.error((Object)(" Status: " + (String)exception.getStatus().getValue() + " Code:" + (String)exception.getCode().getValue() + " Message: " + (String)exception.getMessage().getValue()));
                    return false;
                }
            }
        }
        LOG.error((Object)"Unexpected response from zoho");
        return false;
    }
}

