/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho.batch;

import com.zoho.crm.api.bulkread.APIException;
import com.zoho.crm.api.bulkread.ActionResponse;
import com.zoho.crm.api.bulkread.ActionWrapper;
import com.zoho.crm.api.bulkread.BodyWrapper;
import com.zoho.crm.api.bulkread.BulkReadOperations;
import com.zoho.crm.api.bulkread.Query;
import com.zoho.crm.api.bulkread.SuccessResponse;
import com.zoho.crm.api.modules.MinifiedModule;
import com.zoho.crm.api.util.APIResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public class ZohoBatchJob {
    private static final Logger LOG = Logger.getLogger(ZohoBatchJob.class);

    public String zohoBulkCreateJob(String moduleAPIName) throws Exception {
        String jobID = "";
        BulkReadOperations bulkReadOperations = new BulkReadOperations();
        BodyWrapper bodyWrapper = new BodyWrapper();
        MinifiedModule module = new MinifiedModule();
        module.setAPIName(moduleAPIName);
        bodyWrapper.setQuery(ZohoBatchJob.generateQuery(moduleAPIName, module));
        APIResponse response = bulkReadOperations.createBulkReadJob(bodyWrapper);
        if (response != null && response.isExpected()) {
            Object object = response.getObject();
            if (object instanceof ActionWrapper) {
                ActionWrapper actionWrapper = (ActionWrapper)object;
                for (ActionResponse actionResponse : actionWrapper.getData()) {
                    if (actionResponse instanceof SuccessResponse) {
                        SuccessResponse successResponse = (SuccessResponse)actionResponse;
                        return ZohoBatchJob.fetchJobId(moduleAPIName, successResponse, jobID);
                    }
                    if (!(actionResponse instanceof APIException)) continue;
                    APIException exception = (APIException)actionResponse;
                    ZohoBatchJob.logExceptionDetails(exception);
                }
            } else {
                object = response.getObject();
                if (object instanceof APIException) {
                    APIException exception = (APIException)object;
                    ZohoBatchJob.logExceptionDetails(exception);
                }
            }
        } else {
            LOG.error((Object)"No usable response received");
        }
        return jobID;
    }

    private static String fetchJobId(String moduleAPIName, SuccessResponse successResponse, String jobID) {
        for (Map.Entry entry : successResponse.getDetails().entrySet()) {
            if (!"id".equalsIgnoreCase((String)entry.getKey())) continue;
            jobID = entry.getValue().toString();
        }
        LOG.info((Object)(moduleAPIName + " batch download job " + ((String)successResponse.getMessage().getValue()).toLowerCase()));
        return jobID;
    }

    private static Query generateQuery(String moduleAPIName, MinifiedModule module) {
        Query query = new Query();
        query.setModule(module);
        List<String> fieldAPINames = ZohoBatchJob.populateFieldsList(moduleAPIName);
        query.setFields(fieldAPINames);
        query.setPage(Integer.valueOf(1));
        return query;
    }

    private static void logExceptionDetails(APIException exception) {
        LOG.error((Object)("Status: " + (String)exception.getStatus().getValue()));
        LOG.error((Object)("Code: " + (String)exception.getCode().getValue()));
        LOG.error((Object)"Details: ");
        for (Map.Entry entry : exception.getDetails().entrySet()) {
            LOG.error((Object)((String)entry.getKey() + ": " + String.valueOf(entry.getValue())));
        }
        LOG.error((Object)("Error occurred creating bulk job: " + exception.getMessage()));
    }

    private static List<String> populateFieldsList(String moduleAPIName) {
        ArrayList<String> fieldAPINames = new ArrayList<String>();
        if (StringUtils.equalsIgnoreCase((CharSequence)moduleAPIName, (CharSequence)"Contacts")) {
            fieldAPINames.add("First_Name");
            fieldAPINames.add("Last_Name");
            fieldAPINames.add("Full_Name");
            fieldAPINames.add("Account_Name");
            fieldAPINames.add("Email");
            fieldAPINames.add("Secondary_Email");
            fieldAPINames.add("Lead_Source");
            fieldAPINames.add("User_Account_ID");
            fieldAPINames.add("Contact_Participation");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)moduleAPIName, (CharSequence)"Accounts")) {
            fieldAPINames.add("Account_Name");
            fieldAPINames.add("Europeana_org_ID");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)moduleAPIName, (CharSequence)"API_projects")) {
            fieldAPINames.add("Key");
            fieldAPINames.add("Last_access");
        }
        fieldAPINames.add("Modified_Time");
        return fieldAPINames;
    }
}

