/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho;

import com.zoho.crm.api.bulkread.APIException;
import com.zoho.crm.api.bulkread.BulkReadOperations;
import com.zoho.crm.api.bulkread.FileBodyWrapper;
import com.zoho.crm.api.bulkread.JobDetail;
import com.zoho.crm.api.bulkread.ResponseHandler;
import com.zoho.crm.api.bulkread.ResponseWrapper;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.StreamWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public class ZohoBatchDownload {
    private static final Logger LOG = Logger.getLogger(ZohoBatchDownload.class);
    private static final String COMPLETED = "COMPLETED";

    public String downloadResult(Long jobId) throws SDKException, InterruptedException {
        BulkReadOperations bulkReadOperations = new BulkReadOperations();
        int maxLoops = 20;
        int loops = 0;
        while (loops < maxLoops) {
            ResponseWrapper responseWrapper;
            ResponseHandler responseHandler;
            APIResponse response = bulkReadOperations.getBulkReadJobDetails(jobId);
            if (response != null && response.isExpected() && (responseHandler = (ResponseHandler)response.getObject()) instanceof ResponseWrapper && this.isJobCompleted(responseWrapper = (ResponseWrapper)responseHandler)) {
                return this.downloadCompleted(jobId);
            }
            LOG.debug((Object)("Job not yet finished in loop " + ++loops + ". Retrying in one second."));
            Thread.sleep(1000L);
        }
        return "";
    }

    private boolean isJobCompleted(ResponseWrapper responseWrapper) {
        List jobDetails = responseWrapper.getData();
        for (JobDetail jobDetail : jobDetails) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)jobDetail.getState().getValue()), (CharSequence)COMPLETED)) continue;
            return true;
        }
        return false;
    }

    private String downloadCompleted(Long jobId) throws SDKException {
        BulkReadOperations bulkReadOperations = new BulkReadOperations();
        APIResponse response = bulkReadOperations.downloadResult(jobId);
        if (response != null) {
            if (Arrays.asList(204, 304).contains(response.getStatusCode())) {
                LOG.error((Object)(response.getStatusCode() == 204 ? "No Content" : "Not Modified"));
                return "";
            }
            if (response.isExpected()) {
                ResponseHandler responseHandler = (ResponseHandler)response.getObject();
                if (responseHandler instanceof FileBodyWrapper) {
                    FileBodyWrapper fileBodyWrapper = (FileBodyWrapper)responseHandler;
                    return ZohoBatchDownload.getDownloadedFilePath(fileBodyWrapper);
                }
                if (responseHandler instanceof APIException) {
                    APIException exception = (APIException)responseHandler;
                    ZohoBatchDownload.logExceptionDetails(exception);
                }
            } else {
                LOG.error((Object)"No usable response received");
            }
        }
        return "";
    }

    private static String getDownloadedFilePath(FileBodyWrapper fileBodyWrapper) {
        String string;
        block8: {
            StreamWrapper streamWrapper = fileBodyWrapper.getFile();
            InputStream inputStream = streamWrapper.getStream();
            try {
                File file = new File(streamWrapper.getName());
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
                string = ZohoBatchDownload.unZipFile(file.getCanonicalPath());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error downloading batch job: " + e.getMessage()));
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static void logExceptionDetails(APIException exception) {
        LOG.error((Object)("Status: " + (String)exception.getStatus().getValue()));
        LOG.error((Object)("Code: " + (String)exception.getCode().getValue()));
        LOG.error((Object)"Details: ");
        for (Map.Entry entry : exception.getDetails().entrySet()) {
            LOG.error((Object)((String)entry.getKey() + ": " + String.valueOf(entry.getValue())));
        }
        LOG.error((Object)("Error downloading batch job: " + exception.getMessage()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String unZipFile(String pathToZipFile) {
        Path zipFilePath = Paths.get(pathToZipFile, new String[0]);
        Path zipDir = zipFilePath.getParent();
        try (ZipFile zipFile = new ZipFile(zipFilePath.toFile());){
            File unzippedFile;
            ZipEntry zipEntry;
            String filePath;
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            if (!zipDir.toFile().isDirectory() && !zipDir.toFile().mkdirs()) {
                throw new IOException("failed to create directory " + String.valueOf(zipDir));
            }
            do {
                if (!zipEntries.hasMoreElements()) return null;
            } while ((filePath = ZohoBatchDownload.getUnzippedFilePath(zipEntry = zipEntries.nextElement(), unzippedFile = new File(zipDir.resolve(Path.of(zipEntry.getName(), new String[0])).toString()), zipFile, zipFilePath)) == null);
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            LOG.error((Object)("IOException occurred:" + e.getMessage()));
        }
        return null;
    }

    private static String getUnzippedFilePath(ZipEntry zipEntry, File unzippedFile, ZipFile zipFile, Path zipFilePath) throws IOException {
        String directoryCreationFailed = "failed to create directory ";
        if (zipEntry.isDirectory()) {
            if (!unzippedFile.isDirectory() && !unzippedFile.mkdirs()) {
                throw new IOException(directoryCreationFailed + String.valueOf(unzippedFile));
            }
        } else {
            File unzippedParent = unzippedFile.getParentFile();
            if (!unzippedParent.isDirectory() && !unzippedParent.mkdirs()) {
                throw new IOException(directoryCreationFailed + String.valueOf(unzippedParent));
            }
            return ZohoBatchDownload.createAndgetUnzipFileFilePath(zipFile, zipEntry, unzippedFile, zipFilePath);
        }
        return null;
    }

    private static String createAndgetUnzipFileFilePath(ZipFile zipFile, ZipEntry zipEntry, File unzippedFile, Path zipFilePath) {
        String string;
        block8: {
            InputStream in = zipFile.getInputStream(zipEntry);
            try {
                Files.copy(in, unzippedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Files.deleteIfExists(zipFilePath);
                string = unzippedFile.getCanonicalPath();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error unzipping batch job file:" + e.getMessage()));
                    return null;
                }
            }
            in.close();
        }
        return string;
    }
}

