/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho;

import com.opencsv.bean.CsvToBeanBuilder;
import com.zoho.crm.api.exception.SDKException;
import eu.europeana.api.common.zoho.ZohoConnect;
import eu.europeana.keycloak.SlackConnection;
import eu.europeana.keycloak.zoho.Account;
import eu.europeana.keycloak.zoho.Contact;
import eu.europeana.keycloak.zoho.KeycloakToZohoSyncService;
import eu.europeana.keycloak.zoho.ZohoBatchDownload;
import eu.europeana.keycloak.zoho.ZohoBatchJob;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.Provider;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.services.resource.RealmResourceProvider;

@Provider
public class SyncZohoUserProvider
implements RealmResourceProvider {
    private static final Logger LOG = Logger.getLogger(SyncZohoUserProvider.class);
    public static final String SYNC_REPORT_STATUS_MESSAGE = "{\"text\":\" %s accounts in Zoho where compared against %s accounts in KeyCloak where:  %s accounts are shared and %s contacts were added to Zoho.\n The affiliation for %s accounts was changed or established.\"}\n";
    private final RealmModel realm;
    private final UserProvider userProvider;
    private final ZohoConnect zohoConnect = new ZohoConnect();
    private final KeycloakToZohoSyncService kzSync;
    private List<Account> accounts;
    private List<Contact> contacts;
    HashMap<String, Institute4Hash> instituteMap = new HashMap();
    HashMap<String, String> modifiedUserMap = new HashMap();

    public SyncZohoUserProvider(KeycloakSession session) {
        this.realm = session.getContext().getRealm();
        this.userProvider = session.users();
        this.kzSync = new KeycloakToZohoSyncService(session);
    }

    public Object getResource() {
        return this;
    }

    @Path(value="")
    @GET
    @Produces(value={"application/json"})
    public String zohoSync(@DefaultValue(value="1") @QueryParam(value="days") int days) {
        LOG.info((Object)("ZohoSync called.  Keycloak to zoho sync set to -  " + System.getenv("ENABLE_KEYCLOAK_TO_ZOHO_SYNC")));
        int nrUpdatedUsers = 0;
        int nrOfNewlyAddedContactsInZoho = 0;
        if (this.zohoConnect.getOrCreateAccessToZoho()) {
            String contactsJob;
            String accountsJob;
            ZohoBatchJob zohoBatchJob = new ZohoBatchJob();
            try {
                accountsJob = zohoBatchJob.zohoBulkCreateJob("Accounts");
                contactsJob = zohoBatchJob.zohoBulkCreateJob("Contacts");
            }
            catch (Exception e) {
                LOG.info((Object)("Message: " + e.getMessage() + "; cause: " + String.valueOf(e.getCause())));
                return "Error creating bulk job.";
            }
            ZohoBatchDownload zohoBatchDownload = new ZohoBatchDownload();
            try {
                this.createAccounts(zohoBatchDownload.downloadResult(Long.valueOf(accountsJob)));
                this.createContacts(zohoBatchDownload.downloadResult(Long.valueOf(contactsJob)));
                if (this.accounts != null && !this.accounts.isEmpty() && this.contacts != null && !this.contacts.isEmpty()) {
                    this.synchroniseContacts(days);
                    nrOfNewlyAddedContactsInZoho = this.createNewZohoContacts(this.contacts);
                    nrUpdatedUsers = this.updateKCUsers();
                }
            }
            catch (SDKException | IOException e) {
                LOG.info((Object)("Message: " + e.getMessage() + "; cause: " + String.valueOf(e.getCause()) + String.valueOf(e.getStackTrace())));
                return "Error downloading bulk job.";
            }
        }
        SlackConnection conn = new SlackConnection("SLACK_WEBHOOK_API_AUTOMATION");
        conn.publishStatusReport(this.generateStatusReport(nrUpdatedUsers, nrOfNewlyAddedContactsInZoho));
        return "Done.";
    }

    private int createNewZohoContacts(List<Contact> contacts) {
        return this.kzSync.validateAndCreateZohoContact(contacts);
    }

    private String generateStatusReport(int nrUpdatedUsers, int nrOfNewlyAddedContactsInZoho) {
        return String.format(SYNC_REPORT_STATUS_MESSAGE, this.contacts.size(), this.userProvider.getUsersCount(this.realm), this.modifiedUserMap.size(), nrOfNewlyAddedContactsInZoho, nrUpdatedUsers);
    }

    private void createAccounts(String pathToAccountsCsv) throws IOException {
        this.accounts = new CsvToBeanBuilder((Reader)new FileReader(pathToAccountsCsv)).withType(Account.class).withSkipLines(1).build().parse();
        Files.deleteIfExists(Paths.get(pathToAccountsCsv, new String[0]));
    }

    private void createContacts(String pathToContactsCsv) throws IOException {
        this.contacts = new CsvToBeanBuilder((Reader)new FileReader(pathToContactsCsv)).withType(Contact.class).withSkipLines(1).build().parse();
        Files.deleteIfExists(Paths.get(pathToContactsCsv, new String[0]));
    }

    private void synchroniseContacts(int days) {
        OffsetDateTime toThisTimeAgo = OffsetDateTime.now().minusDays(days);
        for (Account account : this.accounts) {
            this.instituteMap.put(account.getId(), new Institute4Hash(account.getAccountName(), account.getEuropeanaOrgID()));
        }
        this.kzSync.loadKeycloakUsersAndGroups();
        for (Contact contact : this.contacts) {
            this.calculateModifiedZohoUsers(contact, toThisTimeAgo);
            this.kzSync.handleZohoUpdate(contact);
        }
        LOG.info((Object)(this.modifiedUserMap.size() + " contacts records were updated in Zoho in the past " + days + " days."));
        LOG.info((Object)("Zoho Contacts Updated in this sync: " + String.valueOf(this.kzSync.getUpdatedContactList())));
    }

    private void calculateModifiedZohoUsers(Contact contact, OffsetDateTime toThisTimeAgo) {
        if (contact.getModifiedTime().isAfter(toThisTimeAgo)) {
            if (StringUtils.isNotBlank((CharSequence)contact.getAccountID()) && this.instituteMap.get(contact.getAccountID()) != null) {
                this.modifiedUserMap.put(contact.getEmail(), this.instituteMap.get(contact.getAccountID()).getEuropeanaOrgID());
            } else if (StringUtils.isBlank((CharSequence)contact.getAccountID())) {
                this.modifiedUserMap.put(contact.getEmail(), null);
            }
        }
    }

    private int updateKCUsers() {
        int updated = 0;
        LOG.info((Object)"Checking if updated contacts exist in Keycloak ...");
        for (Map.Entry<String, String> affiliatedUser : this.modifiedUserMap.entrySet()) {
            boolean isToUpdateAffiliation;
            UserModel user = this.userProvider.getUserByEmail(this.realm, affiliatedUser.getKey());
            if (user == null) continue;
            String zohoOrgId = affiliatedUser.getValue();
            String affiliationValue = user.getFirstAttribute("affiliation");
            boolean bl = StringUtils.isNotBlank((CharSequence)zohoOrgId) ? !zohoOrgId.equals(affiliationValue) : (isToUpdateAffiliation = StringUtils.isNotBlank((CharSequence)affiliationValue));
            if (isToUpdateAffiliation) {
                user.setSingleAttribute("affiliation", zohoOrgId);
                ++updated;
                LOG.info((Object)(affiliatedUser.getKey() + " affiliation updated from : " + affiliationValue + " to " + zohoOrgId + " in keycloak"));
                continue;
            }
            LOG.info((Object)(affiliatedUser.getKey() + " affiliation will not be updated in keycloak"));
        }
        LOG.info((Object)(updated + " users were found in Keycloak and had their affiliation updated."));
        return updated;
    }

    public void close() {
    }

    public class Institute4Hash {
        private String accountName;
        private String europeanaOrgID;

        public Institute4Hash(String aName, String eID) {
            this.accountName = aName;
            this.europeanaOrgID = eID;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public String getEuropeanaOrgID() {
            return this.europeanaOrgID;
        }
    }
}

