/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho;

import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.record.APIException;
import com.zoho.crm.api.record.ActionHandler;
import com.zoho.crm.api.record.ActionResponse;
import com.zoho.crm.api.record.ActionWrapper;
import com.zoho.crm.api.record.BodyWrapper;
import com.zoho.crm.api.record.Field;
import com.zoho.crm.api.record.Record;
import com.zoho.crm.api.record.RecordOperations;
import com.zoho.crm.api.record.SuccessResponse;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.Choice;
import eu.europeana.keycloak.zoho.Contact;
import eu.europeana.keycloak.zoho.CustomUserDetailsRepository;
import eu.europeana.keycloak.zoho.KeycloakUser;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class KeycloakToZohoSyncService {
    private static final Logger LOG = Logger.getLogger(KeycloakToZohoSyncService.class);
    public static final String CLIENT_OWNER = "client_owner";
    public static final String SHARED_OWNER = "shared_owner";
    public static final String ACCOUNT_HOLDER = "Account holder";
    public static final String API_USER = "API User";
    public static final String API_CUSTOMER = "API Customer";
    private final EntityManager entityManager;
    private final CustomUserDetailsRepository repo;
    private final RealmModel realm;
    private final List<String> updatedContacts = new ArrayList<String>();
    private Map<String, KeycloakUser> userdetails = new HashMap<String, KeycloakUser>();
    private List<String> testUserIds = new ArrayList<String>();

    public KeycloakToZohoSyncService(KeycloakSession session) {
        this.realm = session.getContext().getRealm();
        this.entityManager = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        this.repo = new CustomUserDetailsRepository(this.entityManager);
    }

    public List<String> getUpdatedContactList() {
        return this.updatedContacts;
    }

    public void loadKeycloakUsersAndGroups() {
        this.userdetails = this.repo.listAllUserMails(this.realm.getName());
        String testGroupId = this.repo.findTestGroupId();
        if (testGroupId != null) {
            this.testUserIds = this.repo.findTestGroupUsers(testGroupId);
        }
    }

    public boolean createZohoContact(String userAccountID, String email, String firstName, String lastName, Set<String> participationLevel) throws SDKException {
        String moduleAPIName = "Contacts";
        RecordOperations recordOperations = new RecordOperations(moduleAPIName);
        BodyWrapper bodyWrapper = new BodyWrapper();
        Record newRecord = new Record();
        newRecord.addFieldValue(Field.Contacts.FIRST_NAME, (Object)firstName);
        newRecord.addFieldValue(Field.Contacts.LAST_NAME, (Object)lastName);
        newRecord.addKeyValue("Email", (Object)email);
        List<Choice<String>> participationLevelList = KeycloakToZohoSyncService.getParticipationChoice(participationLevel);
        newRecord.addKeyValue("Contact_Participation", new ArrayList<Choice<String>>(participationLevelList));
        newRecord.addKeyValue("Lead_Source", (Object)new Choice((Object)"Europeana account sign-up form"));
        newRecord.addKeyValue("User_Account_ID", (Object)userAccountID);
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(newRecord);
        bodyWrapper.setData(records);
        HeaderMap headerInstance = new HeaderMap();
        APIResponse response = recordOperations.createRecords(bodyWrapper, headerInstance);
        return this.processResponse((APIResponse<ActionHandler>)response);
    }

    private static List<Choice<String>> getParticipationChoice(Set<String> participationLevel) {
        ArrayList<Choice<String>> participationLevelList = new ArrayList<Choice<String>>();
        if (participationLevel != null) {
            participationLevel.forEach(p -> participationLevelList.add(new Choice(p)));
        }
        return participationLevelList;
    }

    public boolean updateZohoContact(long recordId, String userAccountID, Set<String> participationLevel) throws SDKException {
        ArrayList<Record> records = new ArrayList<Record>();
        Record recordToUpdate = new Record();
        recordToUpdate.addKeyValue("User_Account_ID", (Object)userAccountID);
        recordToUpdate.addKeyValue("Contact_Participation", KeycloakToZohoSyncService.getParticipationChoice(participationLevel));
        records.add(recordToUpdate);
        RecordOperations recordOperations = new RecordOperations("Contacts");
        BodyWrapper request = new BodyWrapper();
        request.setData(records);
        LOG.info((Object)("Updating  zoho contact id :" + recordId));
        APIResponse response = recordOperations.updateRecord(Long.valueOf(recordId), request, new HeaderMap());
        return this.processResponse((APIResponse<ActionHandler>)response);
    }

    private boolean processResponse(APIResponse<ActionHandler> response) {
        if (response != null && response.isExpected()) {
            Object object = response.getObject();
            if (object instanceof ActionWrapper) {
                ActionWrapper actionWrapper = (ActionWrapper)object;
                for (ActionResponse actionResponse : actionWrapper.getData()) {
                    if (actionResponse instanceof SuccessResponse) {
                        return true;
                    }
                    if (!(actionResponse instanceof APIException)) continue;
                    APIException exception = (APIException)actionResponse;
                    LOG.error((Object)("Status: " + (String)exception.getStatus().getValue() + " Code:" + (String)exception.getCode().getValue() + " Message: " + (String)exception.getMessage().getValue()));
                    return false;
                }
            } else {
                object = response.getObject();
                if (object instanceof APIException) {
                    APIException exception = (APIException)object;
                    LOG.error((Object)(" Status: " + (String)exception.getStatus().getValue() + " Code:" + (String)exception.getCode().getValue() + " Message: " + (String)exception.getMessage().getValue()));
                    return false;
                }
            }
        }
        LOG.error((Object)"Unexpected response from zoho");
        return false;
    }

    public void handleZohoUpdate(Contact contact) {
        try {
            KeycloakUser keycloakUser = this.userdetails.get(contact.getEmail());
            if (keycloakUser == null) {
                this.handleUserDissociation(contact);
            } else {
                this.handleZohoContactUpdate(contact, keycloakUser);
            }
        }
        catch (SDKException e) {
            LOG.error((Object)("Exception occurred while updating  contact. " + String.valueOf((Object)e)));
        }
    }

    private void handleUserDissociation(Contact contact) throws SDKException {
        if (this.isSyncEnabled() && StringUtils.isNotEmpty((CharSequence)contact.getUserAccountId()) && this.updateZohoContact(Long.parseLong(contact.getId()), null, KeycloakToZohoSyncService.removeAPIRelatedParticipation(contact.getContactParticipation()))) {
            this.updatedContacts.add(contact.getId() + ":" + contact.getEmail());
        }
    }

    private void handleZohoContactUpdate(Contact contact, KeycloakUser keycloakUser) throws SDKException {
        boolean isPartOfTestGroup = this.isPartOfTestGroup(keycloakUser);
        if (!isPartOfTestGroup) {
            Set<String> participationLevel = this.calculateParticipationLevel(keycloakUser.getAssociatedRoleList(), contact.getContactParticipation());
            this.updateParticipationBasedOnsecondaryMail(contact.getSecondaryEmail(), participationLevel);
            if (this.isSyncEnabled() && this.isToUpdateContact(contact, keycloakUser, participationLevel) && this.updateZohoContact(Long.parseLong(contact.getId()), keycloakUser.getId(), participationLevel)) {
                this.updatedContacts.add(contact.getId() + ":" + contact.getEmail());
            }
        }
    }

    private boolean isPartOfTestGroup(KeycloakUser keycloakUser) {
        return this.testUserIds.contains(keycloakUser.getId());
    }

    public boolean isSyncEnabled() {
        String enableKeycloakToZohoSync = System.getenv("ENABLE_KEYCLOAK_TO_ZOHO_SYNC");
        return StringUtils.isNotEmpty((CharSequence)enableKeycloakToZohoSync) && "true".equals(enableKeycloakToZohoSync);
    }

    private static Set<String> removeAPIRelatedParticipation(String contactParticipation) {
        if (StringUtils.isEmpty((CharSequence)contactParticipation)) {
            return Collections.emptySet();
        }
        return Arrays.stream(contactParticipation.split(";")).filter(participation -> !API_CUSTOMER.equals(participation) && !API_USER.equals(participation) && !ACCOUNT_HOLDER.equals(participation)).collect(Collectors.toCollection(HashSet::new));
    }

    private boolean isToUpdateContact(Contact zohoContact, KeycloakUser keycloakUser, Set<String> participationLevel) {
        if (!keycloakUser.getId().equals(zohoContact.getUserAccountId())) {
            return true;
        }
        if (KeycloakToZohoSyncService.isContactNameChanged(zohoContact, keycloakUser)) {
            return true;
        }
        return KeycloakToZohoSyncService.isparticipationLevelChanged(zohoContact, participationLevel);
    }

    private static boolean isparticipationLevelChanged(Contact zohoContact, Set<String> participationLevel) {
        if (StringUtils.isNotEmpty((CharSequence)zohoContact.getContactParticipation())) {
            String[] levels = zohoContact.getContactParticipation().split(";");
            return levels.length > 0 && Arrays.stream(levels).anyMatch(p -> !participationLevel.contains(p));
        }
        return false;
    }

    private static boolean isContactNameChanged(Contact zohoContact, KeycloakUser keycloakUser) {
        if (StringUtils.isNotEmpty((CharSequence)keycloakUser.getFirstName()) && !keycloakUser.getFirstName().equals(zohoContact.getFirstName())) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)keycloakUser.getLastName()) && !keycloakUser.getLastName().equals(zohoContact.getLastName());
    }

    private void updateParticipationBasedOnsecondaryMail(String secondaryMail, Set<String> participationLevel) {
        KeycloakUser userForSecondaryMail;
        if (StringUtils.isNotEmpty((CharSequence)secondaryMail) && (userForSecondaryMail = this.userdetails.get(secondaryMail)) != null) {
            participationLevel.addAll(this.calculateParticipationLevel(userForSecondaryMail.getAssociatedRoleList(), null));
        }
    }

    public int validateAndCreateZohoContact(List<Contact> zohoContacts) {
        int count = 0;
        ArrayList<String> newContacts = new ArrayList<String>();
        try {
            Map<String, Contact> zohoContactsByPrimaryMail = KeycloakToZohoSyncService.getContactsMap(zohoContacts);
            for (Map.Entry<String, KeycloakUser> userEntry : this.userdetails.entrySet()) {
                KeycloakUser user = userEntry.getValue();
                if (zohoContactsByPrimaryMail.containsKey(user.getEmail()) || this.testUserIds.contains(user.getId())) continue;
                String firstName = user.getFirstName();
                String lastName = KeycloakToZohoSyncService.populateLastNameForContact(user, firstName);
                Set<String> participationLevel = this.calculateParticipationLevel(user.getAssociatedRoleList(), null);
                if (!this.isSyncEnabled()) continue;
                LOG.info((Object)("Creating zoho contact " + user.getEmail()));
                if (this.createZohoContact(user.getId(), user.getEmail(), firstName, lastName, participationLevel)) {
                    newContacts.add(user.getEmail());
                    ++count;
                    continue;
                }
                LOG.error((Object)("Zoho Contact creation failed for " + user.getEmail()));
            }
        }
        catch (SDKException e) {
            LOG.error((Object)("Error occurred while creating contact : " + e.getMessage()));
        }
        LOG.info((Object)("New contacts :" + String.valueOf(newContacts)));
        return count;
    }

    private static String populateLastNameForContact(KeycloakUser user, String firstName) {
        String lastName = user.getLastName();
        if (StringUtils.isEmpty((CharSequence)firstName) && StringUtils.isEmpty((CharSequence)lastName)) {
            lastName = user.getUsername();
        }
        if (StringUtils.isNotEmpty((CharSequence)firstName) && StringUtils.isEmpty((CharSequence)lastName)) {
            lastName = "-";
        }
        return lastName;
    }

    private static Map<String, Contact> getContactsMap(List<Contact> zohoContacts) {
        HashMap<String, Contact> zohoContactsByPrimaryMail = new HashMap<String, Contact>();
        for (Contact c : zohoContacts) {
            if (!StringUtils.isNotEmpty((CharSequence)c.getEmail())) continue;
            zohoContactsByPrimaryMail.put(c.getEmail(), c);
        }
        return zohoContactsByPrimaryMail;
    }

    private Set<String> calculateParticipationLevel(List<String> userRoles, String existingParticipation) {
        HashSet<String> participationLevels = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)existingParticipation)) {
            List<String> existingParticipationLevelList = Arrays.stream(existingParticipation.split(";")).toList();
            participationLevels.addAll(existingParticipationLevelList);
        }
        participationLevels.add(ACCOUNT_HOLDER);
        if (userRoles.contains(SHARED_OWNER)) {
            participationLevels.add(API_CUSTOMER);
        }
        if (userRoles.contains(CLIENT_OWNER)) {
            participationLevels.add(API_USER);
        }
        return participationLevels;
    }
}

