/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho;

import eu.europeana.keycloak.zoho.KeycloakUser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.jboss.logging.Logger;

public class CustomUserDetailsRepository {
    private static final Logger LOG = Logger.getLogger(CustomUserDetailsRepository.class);
    private final EntityManager em;

    public CustomUserDetailsRepository(EntityManager em) {
        this.em = em;
    }

    public String findTestGroupId() {
        String query = "SELECT gi.id FROM  GroupEntity gi WHERE gi.name=:groupname";
        try {
            return (String)this.em.createQuery(query, String.class).setParameter("groupname", (Object)"Europeana Test Users").getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> findTestGroupUsers(String groupId) {
        String query = "SELECT uge.user.id FROM  UserGroupMembershipEntity uge WHERE uge.groupId=:groupID";
        return this.em.createQuery(query, String.class).setParameter("groupID", (Object)groupId).getResultList();
    }

    public Map<String, KeycloakUser> listAllUserMails(String realmName) {
        SessionImpl session;
        SessionFactoryImplementor sessionFactoryImplementor;
        HashMap<String, KeycloakUser> userDetailsMap = new HashMap<String, KeycloakUser>();
        String nativeQueryString = "SELECT\n    u.ID,u.USERNAME,u.EMAIL,u.FIRST_NAME ,u.LAST_NAME,\n    STRING_AGG(kr.NAME, ', ' ORDER BY kr.NAME) AS roles\nFROM\n    {h-schema}USER_ENTITY u\nLEFT JOIN\n    {h-schema}USER_ROLE_MAPPING urm ON u.ID = urm.USER_ID\nLEFT JOIN\n    {h-schema}KEYCLOAK_ROLE kr ON urm.ROLE_ID = kr.ID\nWHERE u.realm_id = %s AND u.enabled = true AND u.service_account_client_link is null\nGROUP BY\n    u.ID,u.USERNAME,u.EMAIL,u.FIRST_NAME ,u.LAST_NAME\nORDER BY u.EMAIL".formatted("'" + realmName + "'");
        Query nativeQuery = this.em.createNativeQuery(nativeQueryString);
        List rows = nativeQuery.getResultList();
        SharedSessionContractImplementor sharedSessionContractImplementor = ((NativeQueryImpl)nativeQuery).getSession();
        if (sharedSessionContractImplementor instanceof SessionImpl && (sessionFactoryImplementor = (session = (SessionImpl)sharedSessionContractImplementor).getSessionFactory()) instanceof SessionFactoryImpl) {
            SessionFactoryImpl factory = (SessionFactoryImpl)sessionFactoryImplementor;
            LOG.info((Object)(" DB Schema name : " + String.valueOf(factory.getProperties().get("hibernate.default_schema"))));
        }
        for (Object[] row : rows) {
            String id = (String)row[0];
            String username = (String)row[1];
            String email = (String)row[2];
            String firstName = (String)row[3];
            String lastName = (String)row[4];
            String roles = (String)row[5];
            userDetailsMap.put(email, new KeycloakUser(id, username, email, firstName, lastName, roles));
        }
        return userDetailsMap;
    }
}

