/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.common.zoho;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ZohoInMemoryTokenStore
implements TokenStore {
    private final Map<String, Token> tokenStore = new ConcurrentHashMap<String, Token>();

    public Token findToken(Token token) {
        if (token instanceof OAuthToken) {
            OAuthToken oauthToken = (OAuthToken)token;
            return this.tokenStore.get(oauthToken.getUserSignature().getName());
        }
        return null;
    }

    public Token findTokenById(String s) {
        return this.tokenStore.get(s);
    }

    public void saveToken(Token token) {
        if (token instanceof OAuthToken) {
            OAuthToken outhToken = (OAuthToken)token;
            this.tokenStore.put(outhToken.getUserSignature().getName(), token);
        }
    }

    public void deleteToken(String s) {
        this.tokenStore.remove(s);
    }

    public List<Token> getTokens() {
        return (List)this.tokenStore.values();
    }

    public void deleteTokens() {
        this.tokenStore.clear();
    }
}

