/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho;

import com.zoho.crm.api.bulkread.APIException;
import com.zoho.crm.api.bulkread.ActionHandler;
import com.zoho.crm.api.bulkread.ActionResponse;
import com.zoho.crm.api.bulkread.ActionWrapper;
import com.zoho.crm.api.bulkread.BodyWrapper;
import com.zoho.crm.api.bulkread.BulkReadOperations;
import com.zoho.crm.api.bulkread.Query;
import com.zoho.crm.api.bulkread.SuccessResponse;
import com.zoho.crm.api.modules.MinifiedModule;
import com.zoho.crm.api.util.APIResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public class ZohoBatchJob {
    private static final Logger LOG = Logger.getLogger(ZohoBatchJob.class);
    private static final String CONTACTS = "Contacts";
    private static final String ACCOUNTS = "Accounts";

    public String ZohoBulkCreateJob(String moduleAPIName) throws Exception {
        String jobID = "";
        BulkReadOperations bulkReadOperations = new BulkReadOperations();
        BodyWrapper bodyWrapper = new BodyWrapper();
        MinifiedModule module = new MinifiedModule();
        module.setAPIName(moduleAPIName);
        Query query = new Query();
        query.setModule(module);
        ArrayList<String> fieldAPINames = new ArrayList<String>();
        if (StringUtils.equalsIgnoreCase((CharSequence)moduleAPIName, (CharSequence)CONTACTS)) {
            fieldAPINames.add("First_Name");
            fieldAPINames.add("Last_Name");
            fieldAPINames.add("Full_Name");
            fieldAPINames.add("Account_Name");
            fieldAPINames.add("Email");
        } else {
            fieldAPINames.add("Account_Name");
            fieldAPINames.add("Europeana_org_ID");
        }
        fieldAPINames.add("Modified_Time");
        query.setFields(fieldAPINames);
        query.setPage(Integer.valueOf(1));
        bodyWrapper.setQuery(query);
        APIResponse response = bulkReadOperations.createBulkReadJob(bodyWrapper);
        if (response != null) {
            if (response.isExpected()) {
                ActionHandler actionHandler = (ActionHandler)response.getObject();
                if (actionHandler instanceof ActionWrapper) {
                    ActionWrapper actionWrapper = (ActionWrapper)actionHandler;
                    List actionResponses = actionWrapper.getData();
                    for (ActionResponse actionResponse : actionResponses) {
                        if (actionResponse instanceof SuccessResponse) {
                            SuccessResponse successResponse = (SuccessResponse)actionResponse;
                            for (Map.Entry entry : successResponse.getDetails().entrySet()) {
                                if (!((String)entry.getKey()).equalsIgnoreCase("id")) continue;
                                jobID = entry.getValue().toString();
                            }
                            LOG.info((Object)(moduleAPIName + " batch download job " + ((String)successResponse.getMessage().getValue()).toLowerCase()));
                            return jobID;
                        }
                        if (!(actionResponse instanceof APIException)) continue;
                        APIException exception = (APIException)actionResponse;
                        LOG.error((Object)("Status: " + (String)exception.getStatus().getValue()));
                        LOG.error((Object)("Code: " + (String)exception.getCode().getValue()));
                        LOG.error((Object)"Details: ");
                        for (Map.Entry entry : exception.getDetails().entrySet()) {
                            LOG.error((Object)((String)entry.getKey() + ": " + entry.getValue()));
                        }
                        LOG.error((Object)("Error occurred creating bulk job: " + exception.getMessage()));
                    }
                } else if (actionHandler instanceof APIException) {
                    APIException exception = (APIException)actionHandler;
                    LOG.error((Object)("Status: " + (String)exception.getStatus().getValue()));
                    LOG.error((Object)("Code: " + (String)exception.getCode().getValue()));
                    LOG.error((Object)"Details: ");
                    for (Map.Entry entry : exception.getDetails().entrySet()) {
                        LOG.error((Object)((String)entry.getKey() + ": " + entry.getValue()));
                    }
                    LOG.error((Object)("Error occurred creating bulk job: " + exception.getMessage()));
                }
            } else {
                LOG.error((Object)"No usable response received");
            }
        }
        return jobID;
    }
}

