/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho;

import com.zoho.crm.api.bulkread.APIException;
import com.zoho.crm.api.bulkread.BulkReadOperations;
import com.zoho.crm.api.bulkread.FileBodyWrapper;
import com.zoho.crm.api.bulkread.JobDetail;
import com.zoho.crm.api.bulkread.ResponseHandler;
import com.zoho.crm.api.bulkread.ResponseWrapper;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.StreamWrapper;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public class ZohoBatchDownload {
    private static final Logger LOG = Logger.getLogger(ZohoBatchDownload.class);
    private static final String COMPLETED = "COMPLETED";

    public String downloadResult(Long jobId) throws Exception {
        Object jobStatus = null;
        BulkReadOperations bulkReadOperations = new BulkReadOperations();
        int maxLoops = 20;
        int loops = 0;
        while (loops < maxLoops) {
            ResponseHandler responseHandler;
            APIResponse response = bulkReadOperations.getBulkReadJobDetails(jobId);
            if (response != null && response.isExpected() && (responseHandler = (ResponseHandler)response.getObject()) instanceof ResponseWrapper) {
                ResponseWrapper responseWrapper = (ResponseWrapper)responseHandler;
                List jobDetails = responseWrapper.getData();
                for (JobDetail jobDetail : jobDetails) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)jobDetail.getState().getValue()), (CharSequence)COMPLETED)) continue;
                    return this.downloadCompleted(jobId);
                }
            }
            LOG.debug((Object)("Job not yet finished in loop " + ++loops + ". Retrying in one second."));
            Thread.sleep(1000L);
        }
        return "";
    }

    private String downloadCompleted(Long jobId) throws Exception {
        Object jobStatus = null;
        BulkReadOperations bulkReadOperations = new BulkReadOperations();
        APIResponse response = bulkReadOperations.downloadResult(jobId);
        if (response != null) {
            if (Arrays.asList(204, 304).contains(response.getStatusCode())) {
                LOG.error((Object)(response.getStatusCode() == 204 ? "No Content" : "Not Modified"));
                return "";
            }
            if (response.isExpected()) {
                ResponseHandler responseHandler = (ResponseHandler)response.getObject();
                if (responseHandler instanceof FileBodyWrapper) {
                    FileBodyWrapper fileBodyWrapper = (FileBodyWrapper)responseHandler;
                    StreamWrapper streamWrapper = fileBodyWrapper.getFile();
                    File file = new File(streamWrapper.getName());
                    InputStream inputStream = streamWrapper.getStream();
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
                        return ZohoBatchDownload.unZipFile(file.getCanonicalPath());
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error downloading batch job: " + e.getMessage()));
                        inputStream.close();
                    }
                } else if (responseHandler instanceof APIException) {
                    APIException exception = (APIException)responseHandler;
                    LOG.error((Object)("Status: " + (String)exception.getStatus().getValue()));
                    LOG.error((Object)("Code: " + (String)exception.getCode().getValue()));
                    LOG.error((Object)"Details: ");
                    for (Map.Entry entry : exception.getDetails().entrySet()) {
                        LOG.error((Object)((String)entry.getKey() + ": " + entry.getValue()));
                    }
                    LOG.error((Object)("Error downloading batch job: " + exception.getMessage()));
                }
            } else {
                LOG.error((Object)"No usable response received");
            }
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    public static String unZipFile(String pathToZipFile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

