/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.zoho;

import com.opencsv.bean.CsvToBeanBuilder;
import eu.europeana.api.common.zoho.ZohoConnect;
import eu.europeana.keycloak.zoho.Account;
import eu.europeana.keycloak.zoho.Contact;
import eu.europeana.keycloak.zoho.ZohoBatchDownload;
import eu.europeana.keycloak.zoho.ZohoBatchJob;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.Provider;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.services.resource.RealmResourceProvider;

@Provider
public class SyncZohoUserProvider
implements RealmResourceProvider {
    private static final Logger LOG = Logger.getLogger(SyncZohoUserProvider.class);
    public static final String SYNC_REPORT_STATUS_MESSAGE = "{\"text\":\" %s accounts in Zoho where compared against %s accounts in KeyCloak where %s accounts are shared and the affiliation for %s accounts was changed or established.\"}";
    private final KeycloakSession session;
    private final RealmModel realm;
    private final UserProvider userProvider;
    private final UserManager userManager;
    private final ZohoConnect zohoConnect = new ZohoConnect();
    private List<Account> accounts;
    private List<Contact> contacts;
    HashMap<String, Institute4Hash> instituteMap = new HashMap();
    HashMap<String, String> modifiedUserMap = new HashMap();

    public SyncZohoUserProvider(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.userProvider = session.users();
        this.userManager = new UserManager(session);
    }

    public Object getResource() {
        return this;
    }

    @Path(value="")
    @GET
    @Produces(value={"application/json"})
    public String zohoSync(@DefaultValue(value="1") @QueryParam(value="days") int days) {
        LOG.info((Object)"ZohoSync called.");
        int nrUpdatedUsers = 0;
        if (this.zohoConnect.getOrCreateAccessToZoho()) {
            String contactsJob;
            String accountsJob;
            ZohoBatchJob zohoBatchJob = new ZohoBatchJob();
            try {
                accountsJob = zohoBatchJob.ZohoBulkCreateJob("Accounts");
                contactsJob = zohoBatchJob.ZohoBulkCreateJob("Contacts");
            }
            catch (Exception e) {
                LOG.info((Object)("Message: " + e.getMessage() + "; cause: " + e.getCause()));
                return "Error creating bulk job.";
            }
            ZohoBatchDownload zohoBatchDownload = new ZohoBatchDownload();
            try {
                this.createAccounts(zohoBatchDownload.downloadResult(Long.valueOf(accountsJob)));
                this.createContacts(zohoBatchDownload.downloadResult(Long.valueOf(contactsJob)));
                if (this.accounts != null && !this.accounts.isEmpty() && this.contacts != null && !this.contacts.isEmpty()) {
                    this.synchroniseContacts(days);
                    nrUpdatedUsers = this.updateKCUsers();
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Message: " + e.getMessage() + "; cause: " + e.getCause()));
                return "Error downloading bulk job.";
            }
        }
        this.publishStatusReport(this.generateStatusReport(nrUpdatedUsers));
        return "Done.";
    }

    private String generateStatusReport(int nrUpdatedUsers) {
        return String.format(SYNC_REPORT_STATUS_MESSAGE, this.contacts.size(), this.userProvider.getUsersCount(this.realm), this.modifiedUserMap.size(), nrUpdatedUsers);
    }

    private void publishStatusReport(String message) {
        LOG.info((Object)("Sending Slack Message : " + message));
        try {
            String slackWebhookApiAutomation = System.getenv("SLACK_WEBHOOK_API_AUTOMATION");
            if (StringUtils.isBlank((CharSequence)slackWebhookApiAutomation)) {
                LOG.error((Object)"Slack webhook not configured, status report will not be published over Slack.");
                return;
            }
            HttpPost httpPost = new HttpPost(slackWebhookApiAutomation);
            StringEntity entity = new StringEntity(message);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                LOG.info((Object)("Received status " + response.getStatusLine().getStatusCode() + " while calling slack!"));
                if (response.getStatusLine().getStatusCode() == 200) {
                    LOG.info((Object)" Successfully sent slack message !");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Exception occurred while sending slack message !! " + e.getMessage()));
        }
    }

    private void createAccounts(String pathToAccountsCsv) throws Exception {
        this.accounts = new CsvToBeanBuilder((Reader)new FileReader(pathToAccountsCsv)).withType(Account.class).withSkipLines(1).build().parse();
        Files.deleteIfExists(Paths.get(pathToAccountsCsv, new String[0]));
    }

    private void createContacts(String pathToContactsCsv) throws Exception {
        this.contacts = new CsvToBeanBuilder((Reader)new FileReader(pathToContactsCsv)).withType(Contact.class).withSkipLines(1).build().parse();
        Files.deleteIfExists(Paths.get(pathToContactsCsv, new String[0]));
    }

    private void synchroniseContacts(int days) {
        OffsetDateTime toThisTimeAgo = OffsetDateTime.now().minusDays(days);
        for (Account account : this.accounts) {
            this.instituteMap.put(account.getID(), new Institute4Hash(account.getAccountName(), account.getEuropeanaOrgID()));
        }
        for (Contact contact : this.contacts) {
            if (!contact.getModifiedTime().isAfter(toThisTimeAgo)) continue;
            if (StringUtils.isNotBlank((CharSequence)contact.getAccountID()) && this.instituteMap.get(contact.getAccountID()) != null) {
                this.modifiedUserMap.put(contact.getEmail(), this.instituteMap.get(contact.getAccountID()).getEuropeanaOrgID());
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)contact.getAccountID())) continue;
            this.modifiedUserMap.put(contact.getEmail(), null);
        }
        LOG.info((Object)(this.modifiedUserMap.size() + " contacts records were updated in Zoho in the past " + days + " days."));
    }

    private int updateKCUsers() {
        int updated = 0;
        LOG.info((Object)"Checking if updated contacts exist in Keycloak ...");
        for (Map.Entry<String, String> affiliatedUser : this.modifiedUserMap.entrySet()) {
            boolean isToUpdateAffiliation;
            UserModel user = this.userProvider.getUserByEmail(this.realm, affiliatedUser.getKey());
            if (user == null) continue;
            String zohoOrgId = affiliatedUser.getValue();
            String affiliationValue = user.getFirstAttribute("affiliation");
            boolean bl = StringUtils.isNotBlank((CharSequence)zohoOrgId) ? !zohoOrgId.equals(affiliationValue) : (isToUpdateAffiliation = StringUtils.isNotBlank((CharSequence)affiliationValue));
            if (isToUpdateAffiliation) {
                user.setSingleAttribute("affiliation", zohoOrgId);
                ++updated;
                LOG.info((Object)(affiliatedUser.getKey() + " affiliation updated from : " + affiliationValue + " to " + zohoOrgId));
                continue;
            }
            LOG.info((Object)(affiliatedUser.getKey() + " will not be updated"));
        }
        LOG.info((Object)(updated + " users were found in Keycloak and had their affiliation updated."));
        return updated;
    }

    public void close() {
    }

    public class Institute4Hash {
        private String accountName;
        private String europeanaOrgID;

        public Institute4Hash(String aName, String eID) {
            this.accountName = aName;
            this.europeanaOrgID = eID;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public String getEuropeanaOrgID() {
            return this.europeanaOrgID;
        }
    }
}

