/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.common.zoho;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.api.logger.Logger;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.SDKConfig;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.dc.DataCenter;
import com.zoho.crm.api.dc.EUDataCenter;
import eu.europeana.api.common.zoho.ZohoAccessConfiguration;
import eu.europeana.api.common.zoho.ZohoInMemoryTokenStore;

public class ZohoConnect {
    private static final org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(ZohoConnect.class);
    private static final DataCenter.Environment ENVIRONMENT = EUDataCenter.PRODUCTION;
    private static ZohoInMemoryTokenStore tokenStore;

    public boolean initialise() throws RuntimeException {
        try {
            Logger zlogger = new Logger.Builder().level(Logger.Levels.INFO).filePath("//opt//keycloak//java_sdk_log.log").build();
            UserSignature userSignature = new UserSignature(ZohoAccessConfiguration.ZOHO_USER_NAME);
            LOG.info((Object)"Connecting to ZOHO");
            LOG.info((Object)("ZOHO client ID: " + ZohoAccessConfiguration.ZOHO_CLIENT_ID));
            LOG.info((Object)("ZOHO client secret: " + ZohoAccessConfiguration.ZOHO_CLIENT_SECRET));
            LOG.info((Object)("ZOHO refresh token: " + ZohoAccessConfiguration.ZOHO_REFRESH_TOKEN));
            LOG.info((Object)("ZOHO redirect URL: " + ZohoAccessConfiguration.ZOHO_REDIRECT_URL));
            OAuthToken token = new OAuthToken.Builder().userSignature(userSignature).clientID(ZohoAccessConfiguration.ZOHO_CLIENT_ID).clientSecret(ZohoAccessConfiguration.ZOHO_CLIENT_SECRET).refreshToken(ZohoAccessConfiguration.ZOHO_REFRESH_TOKEN).redirectURL(ZohoAccessConfiguration.ZOHO_REDIRECT_URL).build();
            LOG.info((Object)"Token built");
            SDKConfig sdkConfig = new SDKConfig.Builder().autoRefreshFields(false).pickListValidation(true).build();
            LOG.info((Object)"SDK configured ...");
            new Initializer.Builder().environment(ENVIRONMENT).token((Token)token).store((TokenStore)tokenStore).SDKConfig(sdkConfig).logger(zlogger).initialize();
            LOG.info((Object)"... and initialised.");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getOrCreateAccessToZoho() {
        if (tokenStore != null) {
            Token tokenById = tokenStore.findTokenById(ZohoAccessConfiguration.ZOHO_USER_NAME);
            if (tokenById != null && tokenById instanceof OAuthToken) {
                LOG.info((Object)("Token Expires in : -" + ((OAuthToken)tokenById).getExpiresIn()));
            }
        } else {
            tokenStore = new ZohoInMemoryTokenStore();
        }
        return this.initialise();
    }
}

