/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.web;

import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.StorageFileName;
import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ActiveDeploymentService;
import eu.europeana.sitemap.service.Deployment;
import eu.europeana.sitemap.web.SitemapFileController;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;

public abstract class AbstractSitemapController {
    private SitemapType sitemapType;
    private ActiveDeploymentService activeDeployment;
    private SitemapFileController readController;

    protected AbstractSitemapController(SitemapType sitemapType, ActiveDeploymentService activeDeployment, SitemapFileController readController) {
        this.sitemapType = sitemapType;
        this.activeDeployment = activeDeployment;
        this.readController = readController;
    }

    public ResponseEntity<InputStreamResource> getSitemapIndex() throws SiteMapNotFoundException {
        Deployment active = this.activeDeployment.getActiveDeployment(this.sitemapType);
        String fileName = StorageFileName.getSitemapIndexFileName((SitemapType)this.sitemapType, (Deployment)active);
        return this.readController.fileXml(fileName);
    }

    public ResponseEntity<InputStreamResource> getSitemapFile(String from, String to) throws SiteMapNotFoundException {
        Deployment active = this.activeDeployment.getActiveDeployment(this.sitemapType);
        String appendix = "?from=" + from + "&to=" + to;
        String fileName = StorageFileName.getSitemapFileName((SitemapType)this.sitemapType, (Deployment)active, (String)appendix);
        return this.readController.fileXml(fileName);
    }
}

