/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service.update;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.config.PortalUrl;
import eu.europeana.sitemap.config.SitemapConfiguration;
import eu.europeana.sitemap.mongo.MongoProvider;
import eu.europeana.sitemap.service.ActiveDeploymentService;
import eu.europeana.sitemap.service.update.AbstractUpdateService;
import eu.europeana.sitemap.service.update.MailService;
import eu.europeana.sitemap.service.update.SitemapGenerator;
import eu.europeana.sitemap.service.update.UpdateRecordServiceUtils;
import jakarta.annotation.PreDestroy;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateRecordService
extends AbstractUpdateService {
    private static final Logger LOG = LogManager.getLogger(UpdateRecordService.class);
    private final SitemapConfiguration config;
    private final PortalUrl portalUrl;
    private final MongoProvider mongoProvider;

    @Autowired
    public UpdateRecordService(S3ObjectStorageClient objectStorage, ActiveDeploymentService deploymentService, MailService mailService, PortalUrl portalUrl, SitemapConfiguration config) {
        super(SitemapType.RECORD, objectStorage, deploymentService, mailService, 45000);
        this.config = config;
        this.portalUrl = portalUrl;
        this.mongoProvider = config.mongoProvider();
    }

    protected void generate(SitemapGenerator sitemapGenerator) {
        MongoCursor cursor = this.getRecordData();
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            String about = doc.get((Object)"about").toString();
            int contentTier = Integer.parseInt(doc.get((Object)"contentTier").toString());
            String metaDataTier = doc.get((Object)"metadataTier").toString();
            Object timestampUpdated = doc.get((Object)"timestampUpdated");
            Date dateUpdated = timestampUpdated == null ? null : (Date)timestampUpdated;
            String url = this.portalUrl.getRecordUrl(about);
            LOG.trace("Adding record {}, contentTier = {}, metadataTier = {} , updated = {}", (Object)url, (Object)contentTier, (Object)metaDataTier, (Object)dateUpdated);
            sitemapGenerator.addItem(url, UpdateRecordServiceUtils.getPriorityForTiers((int)contentTier), dateUpdated);
        }
        cursor.close();
    }

    public String getWebsiteBaseUrl() {
        return this.config.getPortalBaseUrl();
    }

    private MongoCursor<Document> getRecordData() {
        MongoCollection collection = this.mongoProvider.getCollection();
        LOG.info("Starting record query...");
        MongoCursor cursor = collection.aggregate(UpdateRecordServiceUtils.getPipeline((String)this.config.getRecordContentTier(), (String)this.config.getRecordMetadataTier())).batchSize(45000).cursor();
        LOG.info("Query finished. Retrieving records...");
        return cursor;
    }

    @PreDestroy
    public void stopMongoConnections() {
        if (this.mongoProvider != null) {
            this.mongoProvider.close();
        }
    }
}

