/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ReadSitemapService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReadSitemapServiceImpl
implements ReadSitemapService {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;
    private final S3ObjectStorageClient objectStorageProvider;

    @Autowired
    public ReadSitemapServiceImpl(S3ObjectStorageClient objectStorageProvider) {
        this.objectStorageProvider = objectStorageProvider;
    }

    public void getFilesAsStream(OutputStream out) throws IOException {
        OutputStreamWriter result = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        long count = 0L;
        String continuationToken = null;
        do {
            ListObjectsV2Result list = this.objectStorageProvider.listAll(continuationToken);
            continuationToken = list.getNextContinuationToken();
            count += (long)list.getKeyCount();
            List files = list.getObjectSummaries();
            Collections.sort(files, Comparator.comparing(S3ObjectSummary::getLastModified));
            StringBuilder s = new StringBuilder();
            for (S3ObjectSummary file : files) {
                s.append(file.getLastModified());
                s.append('\t');
                if (file.getSize() < 1024L) {
                    s.append(file.getSize()).append(" bytes");
                } else if (file.getSize() < 0x100000L) {
                    s.append(String.format(Locale.getDefault(), "%.2f", (double)file.getSize() / 1024.0)).append("  KB");
                } else if (file.getSize() < 0x40000000L) {
                    s.append(String.format(Locale.getDefault(), "%.2f", (double)file.getSize() / 1048576.0)).append("  MB");
                } else {
                    s.append(String.format(Locale.getDefault(), "%.2f", (double)file.getSize() / 1.073741824E9)).append("  GB");
                }
                s.append('\t');
                s.append(file.getKey());
                s.append('\n');
            }
            result.write(s.toString());
        } while (continuationToken != null);
        result.write("\n");
        result.write("Total " + count + " files");
        result.flush();
    }

    public InputStream getFileAsStream(String fileName) throws SiteMapNotFoundException {
        InputStream result = this.objectStorageProvider.getObjectStream(fileName);
        if (result == null) {
            throw new SiteMapNotFoundException("File " + fileName + " not found!");
        }
        return result;
    }
}

