/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.web;

import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ReadSitemapService;
import jakarta.validation.constraints.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/"})
public class SitemapFileController {
    private static final Logger LOG = LogManager.getLogger(SitemapFileController.class);
    private static final String FILENAME_REGEX = "^[a-zA-Z0-9_=&\\-\\.\\?]*$";
    private static final String INVALID_FILENAME_MSG = "Illegal file name";
    protected final ReadSitemapService service;

    @Autowired
    public SitemapFileController(ReadSitemapService service) {
        this.service = service;
    }

    @GetMapping(value={"list", "files"}, produces={"text/plain"})
    public ResponseEntity<StreamingResponseBody> filesStream() {
        StreamingResponseBody responseBody = out -> this.service.getFilesAsStream(out);
        return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)responseBody);
    }

    @GetMapping(value={"file.txt"}, produces={"text/plain"})
    public ResponseEntity<InputStreamResource> fileTxt(@RequestParam(value="name", defaultValue="") @Pattern(regexp="^[a-zA-Z0-9_=&\\-\\.\\?]*$", message="Illegal file name") @Pattern(regexp="^[a-zA-Z0-9_=&\\-\\.\\?]*$", message="Illegal file name") String fileName) throws SiteMapNotFoundException {
        LOG.debug("Retrieving text file {} ", (Object)fileName);
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("Please provide a file name");
        }
        InputStreamResource result = new InputStreamResource(this.service.getFileAsStream(fileName));
        return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)result);
    }

    @GetMapping(value={"file", "file.xml"}, produces={"text/xml"})
    public ResponseEntity<InputStreamResource> fileXml(@RequestParam(value="name", defaultValue="") @Pattern(regexp="^[a-zA-Z0-9_=&\\-\\.\\?]*$", message="Illegal file name") @Pattern(regexp="^[a-zA-Z0-9_=&\\-\\.\\?]*$", message="Illegal file name") String fileName) throws SiteMapNotFoundException {
        LOG.debug("Retrieving xml file {} ", (Object)fileName);
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("Please provide a file name");
        }
        InputStreamResource result = new InputStreamResource(this.service.getFileAsStream(fileName));
        return ResponseEntity.ok().contentType(MediaType.TEXT_XML).body((Object)result);
    }
}

