/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service.update;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.config.PortalUrl;
import eu.europeana.sitemap.config.SitemapConfiguration;
import eu.europeana.sitemap.exceptions.EntityQueryException;
import eu.europeana.sitemap.exceptions.InvalidApiKeyException;
import eu.europeana.sitemap.exceptions.SiteMapException;
import eu.europeana.sitemap.service.ActiveDeploymentService;
import eu.europeana.sitemap.service.update.AbstractUpdateService;
import eu.europeana.sitemap.service.update.MailService;
import eu.europeana.sitemap.service.update.SitemapGenerator;
import eu.europeana.sitemap.service.update.UpdateEntityService;
import java.io.IOException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateEntityService
extends AbstractUpdateService {
    private static final Logger LOG = LogManager.getLogger(UpdateEntityService.class);
    private static final int ITEMS_PER_SITEMAP_FILE = 15000;
    private static final int ENTITY_QUERY_PAGE_SIZE = 100;
    private static final String ENTITY_QUERY = "*&scope=europeana&type=agent,concept,timespan,organization&fl=id,type&pageSize=100";
    private final SitemapConfiguration config;
    private final PortalUrl portalUrl;
    private CloseableHttpClient httpClient = HttpClients.createDefault();

    @Autowired
    public UpdateEntityService(SitemapConfiguration config, S3ObjectStorageClient objectStorage, ActiveDeploymentService deploymentService, MailService mailService, PortalUrl portalUrl) {
        super(SitemapType.ENTITY, objectStorage, deploymentService, mailService, 15000);
        this.config = config;
        this.portalUrl = portalUrl;
    }

    protected void generate(SitemapGenerator sitemapGenerator) throws SiteMapException {
        long pageNr = 1L;
        long retrieved = 0L;
        long totalEntities = -1L;
        LOG.info("Retrieving entity data...");
        while (retrieved < totalEntities || totalEntities < 0L) {
            EntityData[] entities;
            String entityData = this.getEntityJson(this.config.getEntityApi(), ENTITY_QUERY, pageNr, this.config.getEntityApiKey());
            for (EntityData entity : entities = this.parseEntityData(entityData)) {
                LOG.debug("Adding entity {} with type {}", (Object)entity.getId(), (Object)entity.getType());
                String url = this.portalUrl.getEntityUrl("en", entity.getType(), entity.getId());
                sitemapGenerator.addItem(url, null, null);
            }
            retrieved += (long)entities.length;
            long newTotalEntities = this.getTotalEntitiesCount(entityData);
            if (totalEntities > 0L && newTotalEntities != totalEntities) {
                LOG.warn("Total number of entities has changed during update! Not all entities may be listed");
            }
            totalEntities = newTotalEntities;
            ++pageNr;
        }
    }

    public String getWebsiteBaseUrl() {
        return this.config.getPortalBaseUrl();
    }

    private String getEntityJson(URL entityApi, String query, long pageNr, String wsKey) throws SiteMapException {
        String result = null;
        StringBuilder request = new StringBuilder(entityApi.toString());
        request.append("?query=").append(query).append("&page=").append(pageNr).append("&wskey=").append(wsKey);
        try {
            String requestUrl = request.toString();
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(requestUrl));){
                int responseCode = response.getStatusLine().getStatusCode();
                LOG.debug("Entity query: {}, status code = {}", (Object)request, (Object)responseCode);
                if (responseCode == 401) {
                    throw new InvalidApiKeyException("API key is not valid");
                }
                if (responseCode != 200) {
                    throw new EntityQueryException("Error retrieving entity data: " + response.getStatusLine().getReasonPhrase() + ". Response code " + response.getStatusLine().getStatusCode());
                }
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    LOG.warn("Reponse = null");
                } else {
                    result = EntityUtils.toString((HttpEntity)entity);
                    LOG.debug("Response = {}", (Object)result);
                    EntityUtils.consume((HttpEntity)entity);
                }
            }
        }
        catch (IOException e) {
            throw new EntityQueryException("Error retrieving entity data", (Throwable)e);
        }
        return result;
    }

    private long getTotalEntitiesCount(String entityJson) {
        return (Long)JsonPath.parse((String)entityJson).read("$.partOf.total", Long.class, new Predicate[0]);
    }

    private EntityData[] parseEntityData(String entityJson) {
        return (EntityData[])JsonPath.parse((String)entityJson).read("$.items[*]", EntityData[].class, new Predicate[0]);
    }
}

