/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service.update;

import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.exceptions.SiteMapException;
import eu.europeana.sitemap.exceptions.UpdateAlreadyInProgressException;
import eu.europeana.sitemap.service.ActiveDeploymentService;
import eu.europeana.sitemap.service.Deployment;
import eu.europeana.sitemap.service.update.MailService;
import eu.europeana.sitemap.service.update.SitemapGenerator;
import eu.europeana.sitemap.service.update.UpdateService;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Period;

public abstract class AbstractUpdateService
implements UpdateService {
    private static final Logger LOG = LogManager.getLogger(AbstractUpdateService.class);
    private static final String UPDATE_IN_PROGRESS = "In progress";
    private static final String UPDATE_FINISHED = "Finished";
    private final SitemapType sitemapType;
    private final S3ObjectStorageClient objectStorage;
    private final ActiveDeploymentService deploymentService;
    private final MailService mailService;
    private final int itemsPerSitemap;
    private String updateStatus = "initial";
    private Date updateStartTime;

    protected AbstractUpdateService(SitemapType type, S3ObjectStorageClient objectStorage, ActiveDeploymentService deploymentService, MailService mailService, int itemsPerSitemap) {
        this.sitemapType = type;
        this.objectStorage = objectStorage;
        this.deploymentService = deploymentService;
        this.mailService = mailService;
        this.itemsPerSitemap = itemsPerSitemap;
    }

    public void update() throws SiteMapException {
        this.setUpdateInProgress();
        try {
            Deployment inactive = this.deploymentService.getInactiveDeployment(this.sitemapType);
            LOG.info("Inactive deployment is {}", (Object)inactive);
            this.deploymentService.deleteInactiveFiles(this.sitemapType);
            SitemapGenerator generator = new SitemapGenerator(this.sitemapType, this.objectStorage);
            generator.init(inactive, this.getWebsiteBaseUrl(), this.itemsPerSitemap);
            long generateStartTime = System.currentTimeMillis();
            this.generate(generator);
            generator.finish();
            if (LOG.isInfoEnabled()) {
                LOG.info("{} sitemap generation completed in {}", (Object)this.sitemapType, (Object)this.getDurationText(System.currentTimeMillis() - generateStartTime));
            }
            LOG.debug("Switching deployment...");
            Deployment newDeploy = this.deploymentService.switchDeployment(this.sitemapType);
            LOG.info("New deployment is now {}", (Object)newDeploy);
        }
        catch (SiteMapException | RuntimeException e) {
            String message = "Error updating " + this.sitemapType + " sitemap";
            this.mailService.sendErrorEmail(message + ": " + e.getMessage(), e);
            throw new SiteMapException(message, e);
        }
        finally {
            this.setUpdateDone();
        }
    }

    protected abstract void generate(SitemapGenerator var1) throws SiteMapException;

    protected abstract String getWebsiteBaseUrl();

    public SitemapType getSitemapType() {
        return this.sitemapType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdateInProgress() throws UpdateAlreadyInProgressException {
        AbstractUpdateService abstractUpdateService = this;
        synchronized (abstractUpdateService) {
            if (UPDATE_IN_PROGRESS.equalsIgnoreCase(this.updateStatus)) {
                String msg = "There is already an update in progress (started at " + this.updateStartTime + ")";
                LOG.warn(msg);
                throw new UpdateAlreadyInProgressException(msg);
            }
            this.updateStatus = UPDATE_IN_PROGRESS;
            LOG.info("Starting update process...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdateDone() {
        AbstractUpdateService abstractUpdateService = this;
        synchronized (abstractUpdateService) {
            this.updateStartTime = null;
            this.updateStatus = UPDATE_FINISHED;
            LOG.info("Update {}", (Object)this.updateStatus);
        }
    }

    private String getDurationText(long durationInMs) {
        Period period = new Period(durationInMs);
        String result = period.getDays() >= 1 ? String.format("%d days, %d hours and %d minutes", period.getDays(), period.getHours(), period.getMinutes()) : (period.getHours() >= 1 ? String.format("%d hours and %d minutes", period.getHours(), period.getMinutes()) : (period.getMinutes() >= 1 ? String.format("%d minutes and %d seconds", period.getMinutes(), period.getSeconds()) : String.format("%d.%d seconds", period.getSeconds(), period.getMillis())));
        return result;
    }
}

