/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.StorageFileName;
import eu.europeana.sitemap.service.Deployment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveDeploymentService {
    private static final Logger LOG = LogManager.getLogger(ActiveDeploymentService.class);
    private static final int PROGRESS_INTERVAL = 100;
    private final S3ObjectStorageClient objectStorageProvider;

    @Autowired
    public ActiveDeploymentService(S3ObjectStorageClient objectStorageClient) {
        LOG.debug("Init");
        this.objectStorageProvider = objectStorageClient;
    }

    public Deployment getActiveDeployment(SitemapType sitemapType) {
        Deployment result = null;
        String activeFileName = StorageFileName.getActiveDeploymentFileName((SitemapType)sitemapType);
        LOG.debug("Reading active file {}", (Object)activeFileName);
        try (S3Object s3Object = this.objectStorageProvider.getObject(activeFileName);){
            if (s3Object == null) {
                LOG.error("File {} not present. Initializing new active deployment file...", (Object)activeFileName);
                this.saveToStorageProvider(Deployment.GREEN, activeFileName);
                result = Deployment.GREEN;
            } else {
                String blueGreen = new String(s3Object.getObjectContent().readAllBytes(), StandardCharsets.UTF_8);
                result = Deployment.fromString((String)blueGreen);
            }
        }
        catch (IOException e) {
            LOG.error("Error while processing the file {} to determine the current active site map", (Object)activeFileName, (Object)e);
        }
        LOG.debug("Returning deployment {}", result);
        return result;
    }

    public Deployment getInactiveDeployment(SitemapType sitemapType) {
        if (Deployment.BLUE == this.getActiveDeployment(sitemapType)) {
            return Deployment.GREEN;
        }
        return Deployment.BLUE;
    }

    public long deleteInactiveFiles(SitemapType sitemapType) {
        long result = 0L;
        Deployment inactive = this.getInactiveDeployment(sitemapType);
        String fileNameToDelete = StorageFileName.getSitemapFileName((SitemapType)sitemapType, (Deployment)inactive, null);
        fileNameToDelete = fileNameToDelete.split(".xml")[0];
        String continuationToken = null;
        LOG.info("Deleting all old files with name starting with {} ...", (Object)fileNameToDelete);
        do {
            ListObjectsV2Result list = this.objectStorageProvider.listAll(continuationToken);
            continuationToken = list.getNextContinuationToken();
            List results = list.getObjectSummaries();
            if (results.isEmpty()) {
                LOG.info("No files to remove.");
                continue;
            }
            for (S3ObjectSummary obj : results) {
                result = this.deleteInactiveFile(obj.getKey(), fileNameToDelete, result);
            }
        } while (continuationToken != null);
        LOG.info("Deleted {} old files", (Object)result);
        return result;
    }

    private long deleteInactiveFile(String fileName, String fileNameToDelete, long filesDeleted) {
        if (fileName.startsWith(fileNameToDelete)) {
            LOG.debug("Deleting file {}", (Object)fileName);
            this.objectStorageProvider.deleteObject(fileName);
            if (++filesDeleted > 0L && filesDeleted % 100L == 0L) {
                LOG.info("Deleted {} old files", (Object)filesDeleted);
            }
        }
        return filesDeleted;
    }

    public Deployment switchDeployment(SitemapType sitemapType) {
        Deployment switchTo = this.getInactiveDeployment(sitemapType);
        String activeFileName = StorageFileName.getActiveDeploymentFileName((SitemapType)sitemapType);
        this.saveToStorageProvider(switchTo, activeFileName);
        return switchTo;
    }

    private String saveToStorageProvider(Deployment blueGreen, String activeFileName) {
        LOG.debug("Saving value {} in file {} ", (Object)blueGreen, (Object)activeFileName);
        return this.objectStorageProvider.putObject(activeFileName, blueGreen.toString());
    }
}

