/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;

public class MongoProvider {
    private static final Logger LOG = LogManager.getLogger(MongoProvider.class);
    private final MongoClient mongoClient;
    private final MongoCollection<Document> collection;

    public MongoProvider(String connectionUrl, String database) {
        ConnectionString connection = new ConnectionString(connectionUrl);
        if (StringUtils.isEmpty((CharSequence)database)) {
            database = connection.getDatabase();
        }
        LOG.info("Connecting to Mongo {} database at {}...", (Object)database, (Object)connection.getHosts());
        this.mongoClient = MongoClients.create((ConnectionString)connection);
        this.collection = this.mongoClient.getDatabase(database).getCollection("record");
        LOG.info("Mongo record collection retrieved.");
    }

    public void close() {
        if (this.mongoClient != null) {
            LOG.info("Shutting down connections to Mongo...");
            this.mongoClient.close();
        }
    }

    public MongoCollection<Document> getCollection() {
        return this.collection;
    }
}

