/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.config;

import eu.europeana.sitemap.SitemapType;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@PropertySources(value={@PropertySource(value={"classpath:sitemap.properties"}), @PropertySource(value={"classpath:sitemap.user.properties"}, ignoreResourceNotFound=true)})
public class PortalUrl {
    private static final Logger LOG = LogManager.getLogger(PortalUrl.class);
    @Value(value="${portal.base.url}")
    private String portalBaseUrl;
    @Value(value="${record.portal.path}")
    private String recordPortalPath;
    @Value(value="${entity.portal.path}")
    private String entityPortalPath;

    public String getSitemapIndexUrl(SitemapType type) {
        return this.portalBaseUrl + "/" + type.getFileNameBase() + "-index.xml";
    }

    private static String getSitemapUrlPlain(String baseUrl, SitemapType type, String appendix) {
        return baseUrl + "/" + type.getFileNameBase() + ".xml" + appendix;
    }

    public static String getSitemapUrlEncoded(String baseUrl, SitemapType type, String appendix) {
        return StringEscapeUtils.escapeXml10((String)PortalUrl.getSitemapUrlPlain((String)baseUrl, (SitemapType)type, (String)appendix));
    }

    protected String getSitemapUrlEncoded(SitemapType type, String appendix) {
        return PortalUrl.getSitemapUrlEncoded((String)this.portalBaseUrl, (SitemapType)type, (String)appendix);
    }

    public String getRecordUrl(String europeanaId) {
        return this.portalBaseUrl + this.recordPortalPath + europeanaId;
    }

    public String getEntityUrl(String type, String id) {
        return this.portalBaseUrl + this.entityPortalPath + "/" + this.convertEntityTypeToPortalPath(type) + "/" + this.getEntityIdNumber(id);
    }

    public String getEntityUrl(String language, String type, String id) {
        return this.portalBaseUrl + "/" + language + this.entityPortalPath + "/" + this.convertEntityTypeToPortalPath(type) + "/" + this.getEntityIdNumber(id);
    }

    private String getEntityIdNumber(String id) {
        return id.substring(id.lastIndexOf(47) + 1);
    }

    private String convertEntityTypeToPortalPath(String type) {
        String result = null;
        if ("agent".equalsIgnoreCase(type)) {
            result = "person";
        } else if ("concept".equalsIgnoreCase(type)) {
            result = "topic";
        } else if ("timespan".equalsIgnoreCase(type)) {
            result = "time";
        } else if ("organization".equalsIgnoreCase(type)) {
            result = "organisation";
        }
        if (result == null) {
            LOG.warn("Unknown entity type '{}'", (Object)type);
        }
        return result;
    }
}

