/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap;

import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.exceptions.SiteMapException;
import eu.europeana.sitemap.service.update.UpdateEntityService;
import eu.europeana.sitemap.service.update.UpdateRecordService;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.actuate.autoconfigure.metrics.mongo.MongoMetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.PropertySource;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(exclude={MongoAutoConfiguration.class, MongoMetricsAutoConfiguration.class})
@PropertySource(value={"classpath:build.properties"})
public class SitemapApplication
implements CommandLineRunner {
    private static final Logger LOG = LogManager.getLogger(SitemapApplication.class);
    private UpdateEntityService updateEntityService;
    private UpdateRecordService updateRecordService;

    public SitemapApplication(UpdateRecordService updateRecordService, UpdateEntityService updateEntityService) {
        this.updateRecordService = updateRecordService;
        this.updateEntityService = updateEntityService;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            LOG.info("Starting web server");
            SpringApplication.run(SitemapApplication.class, (String[])args);
            return;
        }
        SitemapApplication.validateArg((String[])args);
        new SpringApplicationBuilder(new Class[]{SitemapApplication.class}).web(WebApplicationType.NONE).run(args);
    }

    private static void validateArg(String[] args) {
        if (args.length > 1) {
            LOG.error("Only 1 argument accepted!");
            System.exit(1);
        }
        String taskArg = args[0];
        if (!SitemapType.RECORD.name().equalsIgnoreCase(taskArg) && !SitemapType.ENTITY.name().equalsIgnoreCase(taskArg)) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unsupported argument '{}'. Supported arguments are '{}' and '{}'", (Object)taskArg, (Object)SitemapType.RECORD.name(), (Object)SitemapType.ENTITY.name());
            }
            System.exit(1);
        }
    }

    public void run(String ... args) {
        if (args.length > 0) {
            LOG.info("Command-line arguments = {}", Arrays.stream(args).toArray());
            String taskArg = args[0];
            UpdateRecordService updateService = SitemapType.RECORD.name().equalsIgnoreCase(taskArg) ? this.updateRecordService : this.updateEntityService;
            LOG.info("Starting automatic updating for {} sitemap...", (Object)updateService.getSitemapType());
            try {
                updateService.update();
            }
            catch (SiteMapException e) {
                LOG.error("Error doing automatic update for {} sitemap", (Object)updateService.getSitemapType(), (Object)e);
            }
        } else {
            LOG.info("No command-line arguments provided");
        }
    }
}

