/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.web;

import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.config.SitemapConfiguration;
import eu.europeana.sitemap.exceptions.SiteMapException;
import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ActiveDeploymentService;
import eu.europeana.sitemap.service.update.UpdateRecordService;
import eu.europeana.sitemap.service.update.UpdateService;
import eu.europeana.sitemap.web.AdminUtils;
import eu.europeana.sitemap.web.SitemapAbstractController;
import eu.europeana.sitemap.web.SitemapFileController;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/record"}, produces={"text/xml", "application/xml"})
public class SitemapRecordController
extends SitemapAbstractController {
    private SitemapConfiguration config;
    private UpdateService updateService;

    public SitemapRecordController(ActiveDeploymentService activeDeployment, SitemapFileController readController, UpdateRecordService updateService, SitemapConfiguration config) {
        super(SitemapType.RECORD, activeDeployment, readController);
        this.config = config;
        this.updateService = updateService;
    }

    @GetMapping(value={"index.xml", "sitemap-record-index.xml"})
    public String getRecordSitemapIndex() throws SiteMapNotFoundException {
        return super.getSitemapIndex();
    }

    @GetMapping(value={"sitemap-record.xml"})
    public String getRecordSitemapFile(@RequestParam(value="from") String from, @RequestParam(value="to") String to) throws SiteMapNotFoundException {
        return super.getSitemapFile(from, to);
    }

    @GetMapping(value={"update"}, produces={"text/plain"})
    public String update(@RequestParam(value="wskey") String wskey, HttpServletResponse response) throws SiteMapException {
        if (AdminUtils.verifyKey((String)this.config.getAdminKey(), (String)wskey)) {
            response.setStatus(202);
            this.updateService.update();
            return "Record sitemap update process is done";
        }
        return null;
    }
}

