/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.web;

import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ReadSitemapService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SitemapFileController {
    private static final Logger LOG = LogManager.getLogger(SitemapFileController.class);
    protected final ReadSitemapService service;

    @Autowired
    public SitemapFileController(ReadSitemapService service) {
        this.service = service;
    }

    @GetMapping(value={"list", "files"}, produces={"text/plain"})
    public String files() {
        return this.service.getFiles();
    }

    @GetMapping(value={"file.txt"}, produces={"text/plain"})
    public String fileTxt(@RequestParam(value="name", defaultValue="") String fileName) throws SiteMapNotFoundException {
        return this.file(fileName);
    }

    @GetMapping(value={"file", "file.xml"}, produces={"text/xml"})
    public String file(@RequestParam(value="name", defaultValue="") String fileName) throws SiteMapNotFoundException {
        LOG.debug("Retrieving file {} ", (Object)fileName);
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("Please provide a file name");
        }
        return this.service.getFileContent(fileName);
    }
}

