/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service.update;

import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class UpdateRecordServiceUtils {
    private static final Logger LOG = LogManager.getLogger(UpdateRecordServiceUtils.class);

    private UpdateRecordServiceUtils() {
    }

    public static String getPriorityForTiers(int contentTier) {
        double priority = (double)Math.round((double)contentTier * 10.0 / 4.0) / 10.0;
        return String.valueOf(priority);
    }

    public static List<BasicDBObject> getPipeline(String contentTier, String metadataTier) {
        BasicDBObject getTiersIndividually = new BasicDBObject("$project", (Object)UpdateRecordServiceUtils.getCommonProjections().append("contentTierValue", (Object)new BasicDBObject("$arrayElemAt", Arrays.asList("$qualityAnnotations.body", 0L))).append("metadataTierValue", (Object)new BasicDBObject("$arrayElemAt", Arrays.asList("$qualityAnnotations.body", -1L))));
        BasicDBObject getTierValues = new BasicDBObject("$project", (Object)UpdateRecordServiceUtils.getCommonProjections().append("contentTier", (Object)new BasicDBObject("$arrayElemAt", Arrays.asList(new BasicDBObject("$split", Arrays.asList("$contentTierValue", "contentTier")), -1L))).append("metadataTier", (Object)new BasicDBObject("$arrayElemAt", Arrays.asList(new BasicDBObject("$split", Arrays.asList("$metadataTierValue", "metadataTier")), -1L))));
        BasicDBObject matchCriteria = UpdateRecordServiceUtils.getMatchCriteria((String)contentTier, (String)metadataTier);
        if (matchCriteria.isEmpty()) {
            return Arrays.asList(getTiersIndividually, getTierValues);
        }
        return Arrays.asList(getTiersIndividually, getTierValues, matchCriteria);
    }

    public static BasicDBObject getCommonProjections() {
        return new BasicDBObject("about", (Object)1L).append("timestampUpdated", (Object)1L);
    }

    private static BasicDBObject getMatchCriteria(String contentTier, String metadataTier) {
        List<String> values;
        ArrayList<BasicDBObject> andStages = new ArrayList<BasicDBObject>();
        if (!contentTier.isEmpty()) {
            LOG.info("Filtering records based on Europeana content Tier {}", (Object)contentTier);
            values = List.of(contentTier.split(","));
            andStages.add(new BasicDBObject("contentTier", (Object)new BasicDBObject("$in", values)));
        }
        if (!metadataTier.isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Filtering records based on Europeana metaData Tier {}", (Object)metadataTier.toUpperCase(Locale.ROOT));
            }
            values = List.of(metadataTier.toUpperCase(Locale.ROOT).split(","));
            andStages.add(new BasicDBObject("metadataTier", (Object)new BasicDBObject("$in", values)));
        }
        if (!andStages.isEmpty()) {
            return new BasicDBObject("$match", (Object)new BasicDBObject("$and", andStages));
        }
        return new BasicDBObject();
    }
}

