/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service.update;

import com.mongodb.AggregationOptions;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.config.PortalUrl;
import eu.europeana.sitemap.config.SitemapConfiguration;
import eu.europeana.sitemap.mongo.MongoProvider;
import eu.europeana.sitemap.service.ActiveDeploymentService;
import eu.europeana.sitemap.service.MailService;
import eu.europeana.sitemap.service.ReadSitemapService;
import eu.europeana.sitemap.service.ResubmitService;
import eu.europeana.sitemap.service.update.SitemapGenerator;
import eu.europeana.sitemap.service.update.UpdateAbstractService;
import eu.europeana.sitemap.service.update.UpdateRecordServiceUtils;
import java.util.Date;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateRecordService
extends UpdateAbstractService {
    private static final Logger LOG = LogManager.getLogger(UpdateRecordService.class);
    private final SitemapConfiguration config;
    private final PortalUrl portalUrl;
    private final MongoProvider mongoProvider;

    @Autowired
    public UpdateRecordService(ObjectStorageClient objectStorage, ActiveDeploymentService deploymentService, ReadSitemapService readSitemapService, ResubmitService resubmitService, MailService mailService, PortalUrl portalUrl, SitemapConfiguration config) {
        super(SitemapType.RECORD, objectStorage, deploymentService, readSitemapService, resubmitService, mailService, 45000);
        this.config = config;
        this.portalUrl = portalUrl;
        this.mongoProvider = config.mongoProvider();
    }

    protected void generate(SitemapGenerator sitemapGenerator) {
        Cursor cursor = this.getRecordDataOnTiers();
        while (cursor.hasNext()) {
            DBObject obj = (DBObject)cursor.next();
            String about = obj.get("about").toString();
            int contentTier = Integer.parseInt(obj.get("contentTier").toString());
            String metaDataTier = obj.get("metadataTier").toString();
            Object timestampUpdated = obj.get("timestampUpdated");
            Date dateUpdated = timestampUpdated == null ? null : (Date)timestampUpdated;
            String url = this.portalUrl.getRecordUrl(about);
            LOG.trace("Adding record {}, contentTier = {}, metadataTier = {} , updated = {}", (Object)url, (Object)contentTier, (Object)metaDataTier, (Object)dateUpdated);
            sitemapGenerator.addItem(url, UpdateRecordServiceUtils.getPriorityForTiers((int)contentTier), dateUpdated);
        }
        cursor.close();
    }

    public String getWebsiteBaseUrl() {
        return this.config.getPortalBaseUrl();
    }

    public String getUpdateInterval() {
        return this.config.getRecordUpdateInterval();
    }

    public boolean doResubmit() {
        return this.config.isRecordResubmit();
    }

    private Cursor getRecordDataOnTiers() {
        DBCollection collection = this.mongoProvider.getCollection();
        AggregationOptions options = AggregationOptions.builder().batchSize(Integer.valueOf(45000)).build();
        LOG.info("Starting record query...");
        Cursor cursor = collection.aggregate(UpdateRecordServiceUtils.getPipeline((String)this.config.getRecordContentTier(), (String)this.config.getRecordMetadataTier()), options);
        LOG.info("Query finished. Retrieving records...");
        return cursor;
    }

    @PreDestroy
    public void stopMongoConnections() {
        if (this.mongoProvider != null) {
            this.mongoProvider.close();
        }
    }
}

