/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.config.PortalUrl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResubmitService {
    private static final Logger LOG = LogManager.getLogger(ResubmitService.class);
    private static final HttpClient HTTP_CLIENT = HttpClientBuilder.create().build();
    private PortalUrl portalUrl;

    @Autowired
    public ResubmitService(PortalUrl portalUrl) {
        this.portalUrl = portalUrl;
    }

    public void notifySearchEngines(SitemapType sitemapType) {
        try {
            URI sitemapFile = new URIBuilder(this.portalUrl.getSitemapIndexUrl(sitemapType)).build();
            LOG.info("Notifying search engines that {} sitemap is updated...", (Object)sitemapType);
            this.resubmitToServices(sitemapFile);
        }
        catch (URISyntaxException e) {
            LOG.error("No valid {} sitemap index url", (Object)sitemapType, (Object)e);
        }
    }

    private void resubmitToServices(URI sitemapFile) {
        try {
            this.resubmitToService("Google", "http://google.com/ping", "sitemap", sitemapFile);
        }
        catch (IOException | URISyntaxException e) {
            LOG.error("Error pinging service", (Throwable)e);
        }
    }

    private void resubmitToService(String serviceName, String serviceUrl, String serviceProperty, URI sitemapFile) throws URISyntaxException, IOException {
        HttpResponse response;
        int statusCode;
        LOG.info("Pinging {} with index = {}", (Object)serviceName, (Object)sitemapFile);
        URIBuilder uriBuilder = new URIBuilder(serviceUrl);
        uriBuilder.setParameter(serviceProperty, sitemapFile.toString());
        HttpGet getRequest = new HttpGet(uriBuilder.build());
        if (LOG.isDebugEnabled()) {
            LOG.debug("request = {} ", (Object)getRequest.getURI());
        }
        if ((statusCode = (response = HTTP_CLIENT.execute((HttpUriRequest)getRequest)).getStatusLine().getStatusCode()) == 200) {
            if (LOG.isInfoEnabled()) {
                LOG.info("{} says OK: {} ", (Object)serviceName, (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        } else {
            LOG.error("{} says {} (status code {})", (Object)serviceName, (Object)response.getStatusLine().getReasonPhrase(), (Object)statusCode);
        }
    }
}

