/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ReadSitemapService;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReadSitemapServiceImpl
implements ReadSitemapService {
    private final ObjectStorageClient objectStorageProvider;

    @Autowired
    public ReadSitemapServiceImpl(ObjectStorageClient objectStorageProvider) {
        this.objectStorageProvider = objectStorageProvider;
        LogManager.getLogger(ReadSitemapServiceImpl.class).debug("init");
    }

    public String getFiles() {
        List files = this.objectStorageProvider.list();
        Collections.sort(files, (o1, o2) -> o1.getLastModified().compareTo(o2.getLastModified()));
        StringBuilder result = new StringBuilder();
        for (StorageObject file : files) {
            result.append(file.getLastModified());
            result.append('\t');
            result.append(file.getName());
            result.append('\n');
        }
        return result.toString();
    }

    public String getFileContent(String fileName) throws SiteMapNotFoundException {
        String fileContent = new String(this.objectStorageProvider.getContent(fileName), StandardCharsets.UTF_8);
        if (fileContent.isEmpty()) {
            throw new SiteMapNotFoundException("File " + fileName + " not found!");
        }
        return fileContent;
    }
}

