/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service.update;

import eu.europeana.sitemap.service.update.UpdateEntityService;
import eu.europeana.sitemap.service.update.UpdateRecordService;
import eu.europeana.sitemap.service.update.UpdateScheduler;
import eu.europeana.sitemap.service.update.UpdateService;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@EnableScheduling
@Import(value={UpdateRecordService.class, UpdateEntityService.class})
public class UpdateScheduler {
    private static final Logger LOG = LogManager.getLogger(UpdateScheduler.class);
    private final List<UpdateService> updateServices;
    private ThreadPoolTaskScheduler scheduler;

    @Autowired
    public UpdateScheduler(List<UpdateService> updateServices) {
        this.updateServices = updateServices;
    }

    @PostConstruct
    public void init() {
        for (UpdateService updateService : this.updateServices) {
            if (StringUtils.isEmpty((Object)updateService.getUpdateInterval())) {
                LOG.warn("No cron settings specified for updating {} sitemaps! Automatic update is off", (Object)updateService.getSitemapType());
                continue;
            }
            if (this.scheduler == null) {
                this.scheduler = new ThreadPoolTaskScheduler();
                this.scheduler.setPoolSize(1);
                this.scheduler.initialize();
            }
            TimeZone timezone = TimeZone.getTimeZone("Europe/Amsterdam");
            LOG.info("{} sitemap update schedule is {} {}", (Object)updateService.getSitemapType(), (Object)updateService.getUpdateInterval(), (Object)timezone.getID());
            this.scheduler.schedule((Runnable)new UpdateRunnable(updateService), (Trigger)new CronTrigger(updateService.getUpdateInterval(), timezone));
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.scheduler != null) {
            LOG.info("Shutting down update scheduler...");
            this.scheduler.shutdown();
        }
    }
}

