/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service.update;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.config.PortalUrl;
import eu.europeana.sitemap.config.SitemapConfiguration;
import eu.europeana.sitemap.mongo.MongoProvider;
import eu.europeana.sitemap.service.ActiveDeploymentService;
import eu.europeana.sitemap.service.MailService;
import eu.europeana.sitemap.service.ReadSitemapService;
import eu.europeana.sitemap.service.ResubmitService;
import eu.europeana.sitemap.service.update.SitemapGenerator;
import eu.europeana.sitemap.service.update.UpdateAbstractService;
import java.util.Date;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateRecordService
extends UpdateAbstractService {
    private static final Logger LOG = LogManager.getLogger(UpdateRecordService.class);
    private static final String ABOUT = "about";
    private static final String LASTUPDATED = "timestampUpdated";
    private static final String COMPLETENESS = "europeanaCompleteness";
    private static final int ITEMS_PER_SITEMAP_FILE = 45000;
    private SitemapConfiguration config;
    private PortalUrl portalUrl;
    private MongoProvider mongoProvider;

    @Autowired
    public UpdateRecordService(ObjectStorageClient objectStorage, ActiveDeploymentService deploymentService, ReadSitemapService readSitemapService, ResubmitService resubmitService, MailService mailService, PortalUrl portalUrl, SitemapConfiguration config) {
        super(SitemapType.RECORD, objectStorage, deploymentService, readSitemapService, resubmitService, mailService, 45000);
        this.config = config;
        this.portalUrl = portalUrl;
        this.mongoProvider = config.mongoProvider();
    }

    protected void generate(SitemapGenerator sitemapGenerator) {
        DBCursor cur = this.getRecordData();
        while (cur.hasNext()) {
            DBObject record = cur.next();
            String about = record.get(ABOUT).toString();
            int completeness = Integer.parseInt(record.get(COMPLETENESS).toString());
            Object timestampUpdated = record.get(LASTUPDATED);
            Date dateUpdated = timestampUpdated == null ? null : (Date)timestampUpdated;
            String url = this.portalUrl.getRecordUrl(about);
            Object completenessStr = completeness > 9 ? "1.0" : "0." + completeness;
            LOG.trace("Adding record {}, completeness = {}, updated = {}", (Object)url, (Object)completeness, (Object)dateUpdated);
            sitemapGenerator.addItem(url, (String)completenessStr, dateUpdated);
        }
        cur.close();
    }

    public String getWebsiteBaseUrl() {
        return this.config.getPortalBaseUrl();
    }

    public String getUpdateInterval() {
        return this.config.getRecordUpdateInterval();
    }

    public boolean doResubmit() {
        return this.config.isRecordResubmit();
    }

    private DBCursor getRecordData() {
        DBCollection col = this.mongoProvider.getCollection();
        BasicDBObject query = new BasicDBObject();
        if (this.config.getRecordMinCompleteness() >= 0) {
            LOG.info("Filtering records based on Europeana Completeness score of at least {}", (Object)this.config.getRecordMinCompleteness());
            query.put(COMPLETENESS, (Object)new BasicDBObject("$gte", (Object)this.config.getRecordMinCompleteness()));
        }
        BasicDBObject fields = new BasicDBObject();
        fields.put(ABOUT, (Object)1);
        fields.put(COMPLETENESS, (Object)1);
        fields.put(LASTUPDATED, (Object)1);
        LOG.info("Starting record query...");
        DBCursor cursor = col.find((DBObject)query, (DBObject)fields).batchSize(45000);
        LOG.info("Query finished. Retrieving records...");
        return cursor;
    }

    @PreDestroy
    public void stopMongoConnections() {
        if (this.mongoProvider != null) {
            this.mongoProvider.close();
        }
    }
}

