/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.sitemap.config.SitemapConfiguration;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MailService {
    private SitemapConfiguration config;
    private JavaMailSender mailSender;

    @Autowired
    public MailService(SitemapConfiguration config) {
        this.config = config;
        this.mailSender = config.mailSender;
    }

    public void sendErrorEmail(String errorMessage, Throwable t) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message);
            helper.setFrom(this.config.getMailFrom());
            helper.setTo(this.config.getMailTo());
            helper.setSubject(errorMessage);
            if (t != null) {
                helper.setText(ExceptionUtils.getStackTrace((Throwable)t));
            }
            this.mailSender.send(message);
            LogManager.getLogger(MailService.class).info("Email error alert was sent");
        }
        catch (RuntimeException | MessagingException me) {
            LogManager.getLogger(MailService.class).error("Error sending email error alert", me);
        }
    }
}

