/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.SitemapType;
import eu.europeana.sitemap.StorageFileName;
import eu.europeana.sitemap.service.Deployment;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.StringPayload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveDeploymentService {
    private static final Logger LOG = LogManager.getLogger(ActiveDeploymentService.class);
    private static final int PROGRESS_INTERVAL = 100;
    private final ObjectStorageClient objectStorageProvider;

    @Autowired
    public ActiveDeploymentService(ObjectStorageClient objectStorageClient) {
        LOG.debug("Init");
        this.objectStorageProvider = objectStorageClient;
    }

    public Deployment getActiveDeployment(SitemapType sitemapType) {
        Deployment result = null;
        String activeFileName = StorageFileName.getActiveDeploymentFileName((SitemapType)sitemapType);
        if (this.objectStorageProvider.isAvailable(activeFileName)) {
            LOG.debug("Reading active file {}", (Object)activeFileName);
            Optional optional = this.objectStorageProvider.get(activeFileName);
            if (optional.isPresent()) {
                StorageObject storageObject = (StorageObject)optional.get();
                try (InputStream in = storageObject.getPayload().openStream();
                     StringWriter writer = new StringWriter();){
                    IOUtils.copy((InputStream)in, (Writer)writer);
                    result = Deployment.fromString((String)writer.toString());
                    storageObject.getPayload().close();
                }
                catch (IOException e) {
                    LOG.error("Error while processing the file {} to determine the current active site map", (Object)activeFileName, (Object)e);
                }
            } else {
                LOG.error("Active file should be present, but was not retrieved!");
            }
        } else {
            LOG.debug("Initializing active deployment file...");
            this.saveToStorageProvider(Deployment.GREEN, activeFileName);
            result = Deployment.GREEN;
        }
        LOG.debug("Returning deployment {}", (Object)result);
        return result;
    }

    public Deployment getInactiveDeployment(SitemapType sitemapType) {
        if (Deployment.BLUE == this.getActiveDeployment(sitemapType)) {
            return Deployment.GREEN;
        }
        return Deployment.BLUE;
    }

    public long deleteInactiveFiles(SitemapType sitemapType) {
        List listFiles = this.objectStorageProvider.list();
        if (listFiles.isEmpty()) {
            LOG.info("No files to remove.");
            return 0L;
        }
        Deployment inactive = this.getInactiveDeployment(sitemapType);
        String fileNameToDelete = StorageFileName.getSitemapFileName((SitemapType)sitemapType, (Deployment)inactive, null);
        fileNameToDelete = fileNameToDelete.split(".xml")[0];
        long i = 0L;
        LOG.info("Deleting all old files with the name {} ...", (Object)fileNameToDelete);
        for (StorageObject obj : listFiles) {
            if (obj.getName().startsWith(fileNameToDelete)) {
                LOG.debug("Deleting file {}", (Object)obj.getName());
                this.objectStorageProvider.delete(obj.getName());
                ++i;
            }
            if (i <= 0L || i % 100L != 0L) continue;
            LOG.info("Deleted {} old files", (Object)i);
        }
        LOG.info("Deleted all {} old files", (Object)i);
        return i;
    }

    public Deployment switchDeployment(SitemapType sitemapType) {
        Deployment switchTo = this.getInactiveDeployment(sitemapType);
        String activeFileName = StorageFileName.getActiveDeploymentFileName((SitemapType)sitemapType);
        this.saveToStorageProvider(switchTo, activeFileName);
        return switchTo;
    }

    private String saveToStorageProvider(Deployment blueGreen, String activeFileName) {
        StringPayload payload = new StringPayload(blueGreen.toString());
        LOG.debug("Saving value {} in file {} ", (Object)blueGreen, (Object)activeFileName);
        return this.objectStorageProvider.put(activeFileName, (Payload)payload);
    }
}

