/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.mongo;

import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MongoProvider {
    private static final Logger LOG = LogManager.getLogger(MongoProvider.class);
    private MongoClient mongoClient;
    private DBCollection collection;

    public MongoProvider(String connectionUrl, String database) {
        MongoClientURI uri = new MongoClientURI(connectionUrl);
        if (StringUtils.isEmpty((CharSequence)database)) {
            database = uri.getDatabase();
        }
        LOG.info("Connecting to Mongo {} database at {}...", (Object)database, (Object)uri.getHosts());
        this.mongoClient = new MongoClient(uri);
        this.collection = this.mongoClient.getDB(database).getCollection("record");
        LOG.info("Mongo collection retrieved.");
    }

    public void close() {
        if (this.mongoClient != null) {
            LOG.info("Shutting down connections to Mongo...");
            this.mongoClient.close();
        }
    }

    public DBCollection getCollection() {
        return this.collection;
    }
}

