/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.config;

import eu.europeana.features.ObjectStorageClient;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.sitemap.exceptions.SiteMapConfigException;
import eu.europeana.sitemap.mongo.MongoProvider;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:sitemap.properties"}), @PropertySource(value={"classpath:sitemap.user.properties"}, ignoreResourceNotFound=true)})
public class SitemapConfiguration {
    @Value(value="${admin.apikey}")
    private String adminKey;
    @Value(value="${portal.base.url}")
    private String portalBaseUrl;
    @Value(value="${record.cron.update}")
    private String recordUpdateInterval;
    @Value(value="${record.resubmit}")
    private boolean recordResubmit;
    @Value(value="${record.min.completeness:0}")
    private int recordMinCompleteness;
    @Value(value="${mongodb.connectionUrl}")
    private String mongoConnectionUrl;
    @Value(value="${mongodb.record.dbname}")
    private String mongoDatabase;
    @Value(value="${entity.cron.update}")
    private String entityUpdateInterval;
    @Value(value="${entity.resubmit}")
    private boolean entityResubmit;
    @Value(value="${entity.api.url}")
    private String entityApiUrl;
    @Value(value="${entity.api.wskey}")
    private String entityApiKey;
    private URL entityApi;
    @Value(value="${s3.key}")
    private String key;
    @Value(value="${s3.secret}")
    private String secret;
    @Value(value="${s3.region}")
    private String region;
    @Value(value="${s3.bucket}")
    private String bucket;
    @Value(value="${s3.endpoint}")
    private String endpoint;
    @Value(value="${spring.mail.from:}")
    private String mailFrom;
    @Value(value="${spring.mail.to:}")
    private String mailTo;
    @Lazy
    @Autowired
    public JavaMailSender mailSender;

    protected SitemapConfiguration() {
        LogManager.getLogger(SitemapConfiguration.class).debug("Init sitemap configuration");
    }

    @PostConstruct
    private void validateConfiguration() throws SiteMapConfigException {
        if (StringUtils.isEmpty((CharSequence)this.portalBaseUrl)) {
            throw new SiteMapConfigException("Property portal.base.url is not set");
        }
        if (StringUtils.isEmpty((CharSequence)this.entityApiUrl)) {
            throw new SiteMapConfigException("Property entity.api.url is not set");
        }
        try {
            this.entityApi = new URL(this.entityApiUrl);
        }
        catch (MalformedURLException e) {
            throw new SiteMapConfigException("Property entity.api.url is incorrect: " + this.entityApiUrl, (Throwable)e);
        }
        this.portalBaseUrl = this.portalBaseUrl.trim();
    }

    @Bean
    public ObjectStorageClient objectStorageClient() {
        if (StringUtils.isEmpty((CharSequence)this.endpoint)) {
            return new S3ObjectStorageClient(this.key, this.secret, this.region, this.bucket);
        }
        return new S3ObjectStorageClient(this.key, this.secret, this.region, this.bucket, this.endpoint);
    }

    @Bean
    public MongoProvider mongoProvider() {
        return new MongoProvider(this.mongoConnectionUrl, this.mongoDatabase);
    }

    public String getPortalBaseUrl() {
        return this.portalBaseUrl;
    }

    public String getRecordUpdateInterval() {
        return this.recordUpdateInterval;
    }

    public boolean isRecordResubmit() {
        return this.recordResubmit;
    }

    public int getRecordMinCompleteness() {
        return this.recordMinCompleteness;
    }

    public String getEntityUpdateInterval() {
        return this.entityUpdateInterval;
    }

    public boolean isEntityResubmit() {
        return this.entityResubmit;
    }

    public String getEntityApiUrl() {
        return this.entityApiUrl;
    }

    public void setEntityApi(URL entityApi) {
        this.entityApi = entityApi;
        this.entityApiUrl = entityApi.toString();
    }

    public String getEntityApiKey() {
        return this.entityApiKey;
    }

    public void setEntityApiKey(String entityApiKey) {
        this.entityApiKey = entityApiKey;
    }

    public URL getEntityApi() {
        return this.entityApi;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public String getAdminKey() {
        return this.adminKey;
    }
}

