/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.config;

import eu.europeana.sitemap.SitemapType;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@PropertySources(value={@PropertySource(value={"classpath:sitemap.properties"}), @PropertySource(value={"classpath:sitemap.user.properties"}, ignoreResourceNotFound=true)})
public class PortalUrl {
    private static final Pattern CHAR_NUMBER_OR_DASH = Pattern.compile("[^-a-zA-Z0-9]");
    @Value(value="${portal.base.url}")
    private String portalBaseUrl;
    @Value(value="${record.portal.path}")
    private String recordPortalPath;
    @Value(value="${entity.portal.path}")
    private String entityPortalPath;

    public String getSitemapIndexUrl(SitemapType type) {
        StringBuilder s = new StringBuilder(this.portalBaseUrl).append('/').append(type.getFileNameBase()).append("-index").append(".xml");
        return s.toString();
    }

    public String getSitemapUrl(SitemapType type, String appendix) {
        return PortalUrl.getSitemapUrl((String)this.portalBaseUrl, (SitemapType)type, (String)appendix, (boolean)true);
    }

    public static String getSitemapUrl(String baseUrl, SitemapType type, String appendix, boolean urlEncode) {
        StringBuilder s = new StringBuilder(baseUrl).append('/').append(type.getFileNameBase()).append(".xml").append(appendix);
        if (urlEncode) {
            return StringEscapeUtils.escapeXml((String)s.toString());
        }
        return s.toString();
    }

    public String getRecordUrl(String europeanaId) {
        return this.portalBaseUrl + this.recordPortalPath + europeanaId;
    }

    public String getEntityUrl(String type, String id) {
        StringBuilder s = new StringBuilder(this.portalBaseUrl).append(this.entityPortalPath).append('/').append(this.convertEntityTypeToPortalPath(type)).append('/').append(this.getEntityIdNumber(id));
        return s.toString();
    }

    public String getEntityUrl(String language, String type, String id, String prefLabel) {
        StringBuilder s = new StringBuilder(this.portalBaseUrl);
        s.append('/').append(language).append(this.entityPortalPath).append('/').append(this.convertEntityTypeToPortalPath(type)).append('/').append(this.getEntityIdNumber(id));
        if (!StringUtils.isEmpty((Object)prefLabel)) {
            s.append('-');
            s.append(this.convertPrefLabel(prefLabel));
        }
        return s.toString();
    }

    private String getEntityIdNumber(String id) {
        return id.substring(id.lastIndexOf(47) + 1);
    }

    private String convertEntityTypeToPortalPath(String type) {
        if ("agent".equalsIgnoreCase(type)) {
            return "person";
        }
        if ("concept".equalsIgnoreCase(type)) {
            return "topic";
        }
        return null;
    }

    private String convertPrefLabel(String prefLabel) {
        String result = prefLabel.replaceAll("\\s", "-").replace("&", "and");
        Matcher matcher = CHAR_NUMBER_OR_DASH.matcher(result);
        return matcher.replaceAll("").toLowerCase(Locale.GERMAN);
    }
}

