/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.web;

import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ReadSitemapService;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SitemapReadController {
    public static final String INDEX_FILE = "europeana-sitemap-index-hashed.xml";
    public static final String ACTIVE_SITEMAP_FILE = "europeana-sitemap-active-xml-file.txt";
    private static final Logger LOG = LogManager.getLogger(SitemapReadController.class);
    private final ReadSitemapService service;

    public SitemapReadController(ReadSitemapService service) {
        this.service = service;
    }

    @RequestMapping(value={"index", "europeana-sitemap-index-hashed.xml"}, method={RequestMethod.GET})
    public String handleSitemapIndex() throws SiteMapNotFoundException {
        return this.service.getFileContent(INDEX_FILE);
    }

    @RequestMapping(value={"europeana-sitemap-hashed.xml"}, method={RequestMethod.GET})
    public String handleSitemapFile(@RequestParam(value="from", required=true) String from, @RequestParam(value="to", required=true) String to) throws SiteMapNotFoundException {
        String fileName = this.getActiveDeployment() + "?from=" + from + "&to=" + to;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving sitemap file {} ", (Object)fileName);
        }
        return this.service.getFileContent(fileName);
    }

    private String getActiveDeployment() throws SiteMapNotFoundException {
        return this.service.getFileContent(ACTIVE_SITEMAP_FILE);
    }

    @RequestMapping(value={"list", "files"}, method={RequestMethod.GET}, produces={"text/plain"})
    public String files(HttpServletResponse response) {
        return this.service.getFiles();
    }

    @RequestMapping(value={"file"}, method={RequestMethod.GET}, produces={"text/plain", "text/xml"})
    public String file(@RequestParam(value="name", required=true, defaultValue="") String fileName, HttpServletResponse response) throws SiteMapNotFoundException {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("Please provide a file name");
        }
        String contents = this.service.getFileContent(fileName);
        if (contents.startsWith("<?xml")) {
            response.setContentType("text/xml");
        } else {
            response.setContentType("text/plain");
        }
        return contents;
    }
}

