/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.web;

import eu.europeana.sitemap.exceptions.SiteMapException;
import eu.europeana.sitemap.service.GenerateSitemapService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SitemapGenerationController {
    private static final Logger LOG = LogManager.getLogger(SitemapGenerationController.class);
    private final GenerateSitemapService updateService;
    @Value(value="${admin.apikey}")
    private String adminKey;

    public SitemapGenerationController(GenerateSitemapService updateService) {
        this.updateService = updateService;
    }

    @RequestMapping(value={"update"}, method={RequestMethod.GET})
    public String update(@RequestParam(value="wskey", required=true) String wskey, HttpServletResponse response) throws SiteMapException {
        if (this.verifyKey(wskey)) {
            response.setStatus(202);
            this.updateService.update();
            return "Update finished";
        }
        return null;
    }

    private boolean verifyKey(String wskey) {
        if (StringUtils.isEmpty((String)this.adminKey)) {
            throw new SecurityException("No updates are allowed");
        }
        if (!this.adminKey.equals(wskey)) {
            throw new SecurityException("Invalid key");
        }
        return true;
    }
}

