/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.sitemap.service.GenerateSitemapService;
import eu.europeana.sitemap.service.UpdateScheduler;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class UpdateScheduler {
    private static final Logger LOG = LogManager.getLogger(UpdateScheduler.class);
    private final GenerateSitemapService mongoSitemapService;
    @Value(value="${scheduler.cron.update}")
    private String updateCronConfig;
    private ThreadPoolTaskScheduler scheduler;

    public UpdateScheduler(GenerateSitemapService mongoSitemapService) {
        this.mongoSitemapService = mongoSitemapService;
    }

    @PostConstruct
    public void init() {
        if (this.updateCronConfig == null) {
            LOG.warn("No update cron settings specified!");
        } else {
            this.scheduler = new ThreadPoolTaskScheduler();
            this.scheduler.setPoolSize(1);
            this.scheduler.initialize();
            TimeZone timezone = TimeZone.getTimeZone("Europe/Amsterdam");
            LOG.info("Cron update schedule is: {} {}", (Object)this.updateCronConfig, (Object)timezone.getID());
            this.scheduler.schedule((Runnable)new UpdateRunnable(this, null), (Trigger)new CronTrigger(this.updateCronConfig, timezone));
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.scheduler != null) {
            LOG.info("Shutting down scheduler...");
            this.scheduler.shutdown();
        }
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ GenerateSitemapService access$200(UpdateScheduler x0) {
        return x0.mongoSitemapService;
    }
}

