/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.exceptions.SiteMapNotFoundException;
import eu.europeana.sitemap.service.ReadSitemapService;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class ReadSitemapServiceImpl
implements ReadSitemapService {
    private final ObjectStorageClient objectStorageProvider;

    public ReadSitemapServiceImpl(ObjectStorageClient objectStorageProvider) {
        this.objectStorageProvider = objectStorageProvider;
    }

    public String getFiles() {
        List files = this.objectStorageProvider.list();
        Collections.sort(files, (o1, o2) -> o1.getLastModified().compareTo(o2.getLastModified()));
        StringBuilder result = new StringBuilder();
        for (StorageObject file : files) {
            result.append(file.getLastModified());
            result.append('\t');
            result.append(file.getName());
            result.append('\n');
        }
        return result.toString();
    }

    public String getFileContent(String fileName) throws SiteMapNotFoundException {
        Optional file = this.objectStorageProvider.get(fileName);
        if (file.isPresent()) {
            return new String(this.objectStorageProvider.getContent(fileName), StandardCharsets.UTF_8);
        }
        throw new SiteMapNotFoundException("File " + fileName + " not found!");
    }

    public String getIndexFileContent() throws SiteMapNotFoundException {
        return this.getFileContent("europeana-sitemap-index-hashed.xml");
    }
}

