/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import eu.europeana.sitemap.exceptions.SiteMapConfigException;
import eu.europeana.sitemap.exceptions.SiteMapException;
import eu.europeana.sitemap.exceptions.UpdateAlreadyInProgressException;
import eu.europeana.sitemap.mongo.MongoProvider;
import eu.europeana.sitemap.service.ActiveSiteMapService;
import eu.europeana.sitemap.service.GenerateSitemapService;
import eu.europeana.sitemap.service.ReadSitemapService;
import eu.europeana.sitemap.service.ResubmitService;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Primary
public class GenerateSitemapServiceImpl
implements GenerateSitemapService {
    private static final Logger LOG = LogManager.getLogger(GenerateSitemapServiceImpl.class);
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String SITEMAP_HEADER = "<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">";
    private static final String URLSET_HEADER = "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xmlns:geo=\"http://www.google.com/geo/schemas/sitemap/1.0\">";
    private static final String URL_OPENING = "<url>";
    private static final String URL_CLOSING = "</url>";
    private static final String LOC_OPENING = "<loc>";
    private static final String LOC_CLOSING = "</loc>";
    private static final char LN = '\n';
    private static final String HTML = ".html";
    private static final String FROM = "?from=";
    private static final String TO = "&to=";
    private static final String SITEMAP_OPENING = "<sitemap>";
    private static final String SITEMAP_CLOSING = "</sitemap>";
    private static final String SITEMAP_HEADER_CLOSING = "</sitemapindex>";
    private static final String URLSET_HEADER_CLOSING = "</urlset>";
    private static final String PRIORITY_OPENING = "<priority>";
    private static final String PRIORITY_CLOSING = "</priority>";
    private static final String LASTMOD_OPENING = "<lastmod>";
    private static final String LASTMOD_CLOSING = "</lastmod>";
    private static final String ABOUT = "about";
    private static final String LASTUPDATED = "timestampUpdated";
    private static final String COMPLETENESS = "europeanaCompleteness";
    private static final String UPDATE_IN_PROGRESS = "In progress";
    private static final String UPDATE_FINISHED = "Finished";
    public static final int NUMBER_OF_ELEMENTS = 45000;
    private final MongoProvider mongoProvider;
    private final ObjectStorageClient objectStorageProvider;
    private final ActiveSiteMapService activeSiteMapService;
    private final ReadSitemapService readSitemapService;
    private final ResubmitService resubmitService;
    @Value(value="${portal.base.url}")
    private String portalBaseUrl;
    @Value(value="${portal.record.urlpath}")
    private String portalRecordUrlPath;
    @Value(value="${min.record.completeness}")
    private int minRecordCompleteness;
    private String status = "initial";
    private Date updateStartTime;

    public GenerateSitemapServiceImpl(MongoProvider mongoProvider, ObjectStorageClient objectStorageProvider, ActiveSiteMapService activeSiteMapService, ReadSitemapService readSitemapService, ResubmitService resubmitService) {
        this.mongoProvider = mongoProvider;
        this.objectStorageProvider = objectStorageProvider;
        this.activeSiteMapService = activeSiteMapService;
        this.readSitemapService = readSitemapService;
        this.resubmitService = resubmitService;
    }

    @PostConstruct
    private void init() throws SiteMapConfigException {
        if (StringUtils.isEmpty((Object)this.portalBaseUrl)) {
            throw new SiteMapConfigException("Portal.base.url is not set");
        }
        this.portalBaseUrl = this.portalBaseUrl.trim();
        if (StringUtils.isEmpty((Object)this.portalRecordUrlPath)) {
            throw new SiteMapConfigException("Portal.record.urlpath is not set");
        }
        this.portalRecordUrlPath = this.portalRecordUrlPath.trim();
    }

    public void generate() {
        DBCollection col = this.mongoProvider.getCollection();
        BasicDBObject query = new BasicDBObject();
        if (this.minRecordCompleteness >= 0) {
            LOG.info("Filtering records based on Europeana Completeness score of at least {}", (Object)this.minRecordCompleteness);
            query.put(COMPLETENESS, (Object)new BasicDBObject("$gte", (Object)this.minRecordCompleteness));
        }
        BasicDBObject fields = new BasicDBObject();
        fields.put(ABOUT, (Object)1);
        fields.put(COMPLETENESS, (Object)1);
        fields.put(LASTUPDATED, (Object)1);
        LOG.info("Starting record query...");
        DBCursor cur = col.find((DBObject)query, (DBObject)fields).batchSize(45000);
        LOG.info("Query finished. Retrieving records...");
        long from = 0L;
        long nrRecords = 0L;
        int nrSitemaps = 0;
        StringBuilder master = new StringBuilder();
        master.append(XML_HEADER).append('\n');
        master.append(SITEMAP_HEADER).append('\n');
        long fileStartTime = System.currentTimeMillis();
        StringBuilder slave = this.initializeSlaveGeneration();
        while (cur.hasNext()) {
            DBObject obj = cur.next();
            String about = obj.get(ABOUT).toString();
            int completeness = Integer.parseInt(obj.get(COMPLETENESS).toString());
            Object timestampUpdated = obj.get(LASTUPDATED);
            Date dateUpdated = timestampUpdated == null ? null : (Date)timestampUpdated;
            slave.append(URL_OPENING).append('\n').append(LOC_OPENING).append(this.portalBaseUrl).append(this.portalRecordUrlPath).append(about).append(HTML).append(LOC_CLOSING).append('\n').append(PRIORITY_OPENING).append(completeness > 9 ? "1.0" : "0." + completeness).append(PRIORITY_CLOSING).append('\n').append(this.generateLastModified(dateUpdated).toString()).append(URL_CLOSING).append('\n');
            if (++nrRecords <= 0L || nrRecords % 45000L != 0L && cur.hasNext()) continue;
            String fromToText = FROM + from + TO + nrRecords;
            String indexEntry = "europeana-sitemap-hashed.xml" + fromToText;
            master.append(SITEMAP_OPENING).append('\n').append(LOC_OPENING).append(StringEscapeUtils.escapeXml((String)(this.portalBaseUrl + "/" + indexEntry))).append(LOC_CLOSING).append('\n').append(SITEMAP_CLOSING).append('\n');
            slave.append(URLSET_HEADER_CLOSING);
            String fileName = this.activeSiteMapService.getInactiveFile() + fromToText;
            this.saveToStorage(fileName, slave.toString());
            long now = System.currentTimeMillis();
            LOG.info("Created sitemap file {} in {} ms", (Object)fileName, (Object)(now - fileStartTime));
            fileStartTime = now;
            slave = this.initializeSlaveGeneration();
            from = nrRecords;
            ++nrSitemaps;
        }
        cur.close();
        master.append(SITEMAP_HEADER_CLOSING);
        this.saveToStorage("europeana-sitemap-index-hashed.xml", master.toString());
        LOG.info("Records processed {}, written {} sitemap files and 1 sitemap index file", (Object)nrRecords, (Object)nrSitemaps);
    }

    private StringBuilder initializeSlaveGeneration() {
        return new StringBuilder().append(XML_HEADER).append('\n').append(URLSET_HEADER).append('\n');
    }

    private StringBuilder generateLastModified(Date lastModifiedDate) {
        StringBuilder result = new StringBuilder();
        if (lastModifiedDate != null) {
            result.append(LASTMOD_OPENING);
            result.append(DateFormatUtils.format((Date)lastModifiedDate, (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
            result.append(LASTMOD_CLOSING);
            result.append('\n');
        }
        return result;
    }

    private void saveToStorage(String key, String value) {
        try {
            ByteArrayPayload payload = new ByteArrayPayload(value.getBytes(StandardCharsets.UTF_8));
            String eTag = this.objectStorageProvider.put(key, (Payload)payload);
            boolean siteMapCacheFileExists = this.checkIfFileExists(key);
            if (StringUtils.isEmpty((Object)eTag) || !siteMapCacheFileExists) {
                int maxAttempts = 3;
                for (int nSaveAttempts = 1; nSaveAttempts < maxAttempts && (StringUtils.isEmpty((Object)eTag) || !siteMapCacheFileExists); ++nSaveAttempts) {
                    LOG.info("Failed to save to storage provider (filename={}, siteMapCacheFileExists={})", (Object)key, (Object)siteMapCacheFileExists);
                    long timeout = (long)nSaveAttempts * 5000L;
                    LOG.info("Waiting {} seconds to try again", (Object)(timeout / 1000L));
                    Thread.sleep(timeout);
                    LOG.info("Retrying to save the file");
                    eTag = this.objectStorageProvider.put(key, (Payload)payload);
                    siteMapCacheFileExists = this.checkIfFileExists(key);
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Saving to storage was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private boolean checkIfFileExists(String id) {
        return this.objectStorageProvider.isAvailable(id);
    }

    public MongoProvider getMongoProvider() {
        return this.mongoProvider;
    }

    public ObjectStorageClient getObjectStorageProvider() {
        return this.objectStorageProvider;
    }

    private void delete() {
        List list = this.objectStorageProvider.list();
        if (list.isEmpty()) {
            LOG.info("No files to remove.");
        }
        int i = 0;
        String inactiveFilename = this.activeSiteMapService.getInactiveFile();
        LOG.info("Deleting all old files with the name {}", (Object)inactiveFilename);
        for (StorageObject obj : list) {
            if (obj.getName().contains(inactiveFilename)) {
                this.objectStorageProvider.delete(obj.getName());
                ++i;
            }
            if (i <= 0 || i % 100 != 0) continue;
            LOG.info("Removed {} old files", (Object)i);
        }
        LOG.info("Removed all {} old files", (Object)i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdateInProgress() throws UpdateAlreadyInProgressException {
        GenerateSitemapServiceImpl generateSitemapServiceImpl = this;
        synchronized (generateSitemapServiceImpl) {
            if (UPDATE_IN_PROGRESS.equalsIgnoreCase(this.status)) {
                String msg = "There is already an update in progress (started at " + this.updateStartTime + ")";
                LOG.warn(msg);
                throw new UpdateAlreadyInProgressException(msg);
            }
            this.status = UPDATE_IN_PROGRESS;
            this.updateStartTime = new Date();
            LOG.info("Starting update process...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdateDone() {
        GenerateSitemapServiceImpl generateSitemapServiceImpl = this;
        synchronized (generateSitemapServiceImpl) {
            this.updateStartTime = null;
            this.status = UPDATE_FINISHED;
            LOG.info("Status: {}", (Object)this.status);
        }
    }

    public void update() throws SiteMapException {
        this.setUpdateInProgress();
        try {
            this.delete();
            String oldIndex = this.readSitemapService.getIndexFileContent();
            long startTime = System.currentTimeMillis();
            this.generate();
            LOG.info("Sitemap generation completed in {} seconds", (Object)((System.currentTimeMillis() - startTime) / 1000L));
            String activeFile = this.activeSiteMapService.switchFile();
            LOG.info("Switched active sitemap to {}", (Object)activeFile);
            String newIndex = this.readSitemapService.getIndexFileContent();
            if (newIndex.equalsIgnoreCase(oldIndex)) {
                LOG.info("Index has not changed");
            } else {
                LOG.info("Index has changed");
                this.resubmitService.notifySearchEngines();
            }
        }
        catch (Exception e) {
            LOG.error("Error updating sitemap {}", (Object)e.getMessage(), (Object)e);
            throw new SiteMapException("Error updating sitemap", (Throwable)e);
        }
        finally {
            this.setUpdateDone();
        }
    }
}

