/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.service;

import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.StringPayload;
import org.springframework.stereotype.Service;

@Service
public class ActiveSiteMapService {
    private static final Logger LOG = LogManager.getLogger(ActiveSiteMapService.class);
    public static final String EUROPEANA_SITEMAP_HASHED_GREEN = "europeana-sitemap-hashed-green.xml";
    public static final String EUROPEANA_SITEMAP_HASHED_BLUE = "europeana-sitemap-hashed-blue.xml";
    public static final String EUROPEANA_ACTIVE_SITEMAP_SWITCH_FILE = "europeana-sitemap-active-xml-file.txt";
    private final ObjectStorageClient objectStorageProvider;

    public ActiveSiteMapService(ObjectStorageClient objectStorageClient) {
        this.objectStorageProvider = objectStorageClient;
    }

    public String getActiveFile() {
        String result = "";
        String activeSiteMapFile = EUROPEANA_ACTIVE_SITEMAP_SWITCH_FILE;
        Optional withoutBody = this.objectStorageProvider.getWithoutBody(activeSiteMapFile);
        StorageObject storageObjectValue = null;
        if (withoutBody.isPresent()) {
            StringWriter writer = new StringWriter();
            Optional storageObject = this.objectStorageProvider.get(activeSiteMapFile);
            if (storageObject.isPresent()) {
                storageObjectValue = (StorageObject)storageObject.get();
                try (InputStream in = storageObjectValue.getPayload().openStream();){
                    IOUtils.copy((InputStream)in, (Writer)writer);
                    result = writer.toString();
                    storageObjectValue.getPayload().close();
                }
                catch (IOException e) {
                    LOG.error("Error while processing the file {} to determine the current active site map", (Object)activeSiteMapFile, (Object)e);
                }
            } else {
                LOG.error("Active file not present!");
            }
        } else {
            this.saveToStorageProvider(EUROPEANA_SITEMAP_HASHED_GREEN);
            result = EUROPEANA_SITEMAP_HASHED_GREEN;
        }
        return result;
    }

    public String getInactiveFile() {
        String result = EUROPEANA_SITEMAP_HASHED_GREEN.equals(this.getActiveFile()) ? EUROPEANA_SITEMAP_HASHED_BLUE : EUROPEANA_SITEMAP_HASHED_GREEN;
        return result;
    }

    public String switchFile() {
        String result = this.getInactiveFile();
        this.saveToStorageProvider(result);
        return result;
    }

    private String saveToStorageProvider(String value) {
        StringPayload payload = new StringPayload(value);
        return this.objectStorageProvider.put(EUROPEANA_ACTIVE_SITEMAP_SWITCH_FILE, (Payload)payload);
    }
}

