/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap.mongo;

import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class MongoProvider {
    private static final Logger LOG = LogManager.getLogger(MongoProvider.class);
    private MongoClient mongoClient;
    private DBCollection collection;

    public MongoProvider(String mongoHosts, String port, String authDatabase, String username, String password, String database) {
        String[] addresses = mongoHosts.split(",");
        ArrayList<ServerAddress> mongoAddresses = new ArrayList<ServerAddress>(addresses.length);
        for (String address : addresses) {
            ServerAddress mongoAddress = new ServerAddress(address, Integer.parseInt(port));
            mongoAddresses.add(mongoAddress);
        }
        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
            MongoCredential credential = MongoCredential.createCredential((String)username, (String)authDatabase, (char[])password.toCharArray());
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            credentials.add(credential);
            this.mongoClient = new MongoClient(mongoAddresses, credentials);
        } else {
            this.mongoClient = new MongoClient(mongoAddresses);
        }
        LOG.info("Connected to Mongo at {} ", mongoAddresses);
        this.collection = this.mongoClient.getDB(database).getCollection("record");
    }

    public void close() {
        LOG.info("Shutting down connections to Mongo...");
        this.mongoClient.close();
    }

    public DBCollection getCollection() {
        return this.collection;
    }
}

