/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.sitemap;

import eu.europeana.features.ObjectStorageClient;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.sitemap.mongo.MongoProvider;
import eu.europeana.sitemap.service.ActiveSiteMapService;
import eu.europeana.sitemap.service.GenerateSitemapService;
import eu.europeana.sitemap.service.GenerateSitemapServiceImpl;
import eu.europeana.sitemap.service.ReadSitemapService;
import eu.europeana.sitemap.service.ReadSitemapServiceImpl;
import eu.europeana.sitemap.service.ResubmitService;
import eu.europeana.sitemap.service.UpdateScheduler;
import eu.europeana.sitemap.web.context.SocksProxyConfigInjector;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableAutoConfiguration(exclude={MongoAutoConfiguration.class})
@PropertySources(value={@PropertySource(value={"classpath:sitemap.properties"}), @PropertySource(value={"classpath:sitemap.user.properties"}, ignoreResourceNotFound=true)})
public class SitemapApplication
extends SpringBootServletInitializer {
    @Value(value="${s3.key}")
    private String key;
    @Value(value="${s3.secret}")
    private String secret;
    @Value(value="${s3.region}")
    private String region;
    @Value(value="${s3.bucket}")
    private String bucket;
    @Value(value="${mongo.hosts}")
    private String hosts;
    @Value(value="${mongo.port}")
    private String port;
    @Value(value="${mongo.authDatabase}")
    private String authDatabase;
    @Value(value="${mongo.username}")
    private String username;
    @Value(value="${mongo.password}")
    private String password;
    @Value(value="${mongo.database}")
    private String database;

    @Bean
    public MongoProvider mongoProvider() {
        return new MongoProvider(this.hosts, this.port, this.authDatabase, this.username, this.password, this.database);
    }

    @Bean
    public ObjectStorageClient objectStorageClient() {
        return new S3ObjectStorageClient(this.key, this.secret, this.region, this.bucket);
    }

    @Bean
    public UpdateScheduler updateScheduler() {
        return new UpdateScheduler((GenerateSitemapService)this.generateSitemapService());
    }

    @Bean
    public ResubmitService resubmitSitemapService() {
        return new ResubmitService();
    }

    @Bean
    public ActiveSiteMapService activeSitemapService() {
        return new ActiveSiteMapService(this.objectStorageClient());
    }

    @Bean
    public ReadSitemapServiceImpl readSitemapService() {
        return new ReadSitemapServiceImpl(this.objectStorageClient());
    }

    @Bean
    public GenerateSitemapServiceImpl generateSitemapService() {
        return new GenerateSitemapServiceImpl(this.mongoProvider(), this.objectStorageClient(), this.activeSitemapService(), (ReadSitemapService)this.readSitemapService(), this.resubmitSitemapService());
    }

    public static void main(String[] args) {
        try {
            SitemapApplication.injectSocksProxySettings();
            SpringApplication.run(SitemapApplication.class, (String[])args);
        }
        catch (IOException e) {
            LogManager.getLogger(SitemapApplication.class).fatal("Error reading properties", (Throwable)e);
            System.exit(-1);
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        try {
            SitemapApplication.injectSocksProxySettings();
            super.onStartup(servletContext);
        }
        catch (IOException e) {
            throw new ServletException("Error reading properties", (Throwable)e);
        }
    }

    private static void injectSocksProxySettings() throws IOException {
        SocksProxyConfigInjector socksConfig = new SocksProxyConfigInjector("sitemap.properties");
        try {
            socksConfig.addProperties("sitemap.user.properties");
        }
        catch (IOException e) {
            LogManager.getLogger(SitemapApplication.class).warn("Cannot read sitemap.user.properties file");
        }
        socksConfig.inject();
    }
}

